import { Carousel, Rating } from "flowbite-react"
import { ClientOnly } from "remix-utils"
import Next from "../../public/assets/img/next-btn.webp"
import Prev from "../../public/assets/img/back-btn.webp"

const CarouselResenas = ({resenas}) => {
    return (
        <ClientOnly fallback={''}>
            { () => (
                <>
                    {/*0 to 640*/}
                    <Carousel
                        slideInterval={10000}
                        className="sm:hidden md:hidden lg:hidden xl:hidden"
                        indicators={false}
                        leftControl={<div><img src={Prev} alt="Anterior" className="relative -left-10 lg:-left-14 w-20" /></div>}
                        rightControl={<div><img src={Next} alt="Siguiente" className="relative left-10 lg:left-14 w-20" /></div>}
                    >
                        {
                            (
                                () => {
                                    const options = [];
                                    for (let i = 0; i < Math.ceil(resenas.length/1); i++) {
                                        options.push(<div key={i} className="flex">
                                            {
                                                resenas.map( (item, idx) => (
                                                    ( idx >= 1*i && idx < 1*(i+1) ) ?
                                                        <div key={idx} className="w-1/1 flex flex-col justify-between items-between bg-white m-2 p-5 h-[344px]">
                                                            <div>
                                                                <div className="flex justify-between items-between">
                                                                    <p className="text-eGray font-MontserratSemiBold">{item.vc_cliente}</p>
                                                                    <Rating>
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                    </Rating>
                                                                </div>
                                                                <p className="text-xs text-eGray py-5">{item.tx_resena}</p>
                                                            </div>
                                                            <p className="text-end text-sm">{new Date(item.created_at).getDate()}/{new Date(item.created_at).getMonth()}/{new Date(item.created_at).getFullYear()}</p>
                                                        </div>
                                                    : ""
                                                ))
                                            }
                                        </div>)
                                    }
                                    return options;
                                }
                            )()
                        }
                    </Carousel>

                    {/*640 to 768*/}
                    <Carousel
                        slideInterval={10000}
                        className="hidden sm:block md:hidden lg:hidden xl:hidden"
                        indicators={false}
                        leftControl={<div><img src={Prev} alt="Anterior" className="relative -left-14 w-20" /></div>}
                        rightControl={<div><img src={Next} alt="Siguiente" className="relative left-14 w-20" /></div>}
                    >
                        {
                            (
                                () => {
                                    const options = [];
                                    for (let i = 0; i < Math.ceil(resenas.length/2); i++) {
                                        options.push(<div key={i} className="flex">
                                            {
                                                resenas.map( (item, idx) => (
                                                    ( idx >= 2*i && idx < 2*(i+1) ) ?
                                                        <div key={idx} className="w-1/2 flex flex-col justify-between items-between bg-white m-2 p-5 h-[344px]">
                                                            <div>
                                                                <div className="flex justify-between items-between">
                                                                    <p className="text-eGray font-MontserratSemiBold">{item.vc_cliente}</p>
                                                                    <Rating>
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                    </Rating>
                                                                </div>
                                                                <p className="text-sm text-eGray py-5">{item.tx_resena}</p>
                                                            </div>
                                                            <p className="text-end text-sm">{new Date(item.created_at).getDate()}/{new Date(item.created_at).getMonth()}/{new Date(item.created_at).getFullYear()}</p>
                                                        </div>
                                                    : ""
                                                ))
                                            }
                                        </div>)
                                    }
                                    return options;
                                }
                            )()
                        }
                    </Carousel>

                    {/*768 to 1024*/}
                    <Carousel
                        slideInterval={10000}
                        className="hidden sm:hidden md:block lg:hidden xl:hidden"
                        indicators={false}
                        leftControl={<div><img src={Prev} alt="Anterior" className="relative -left-14 w-20" /></div>}
                        rightControl={<div><img src={Next} alt="Siguiente" className="relative left-14 w-20" /></div>}
                    >
                        {
                            (
                                () => {
                                    const options = [];
                                    for (let i = 0; i < Math.ceil(resenas.length/3); i++) {
                                        options.push(<div key={i} className="flex">
                                            {
                                                resenas.map( (item, idx) => (
                                                    ( idx >= 3*i && idx < 3*(i+1) ) ?
                                                        <div key={idx} className="w-1/3 flex flex-col justify-between items-between bg-white m-2 p-5 h-[344px]">
                                                            <div>
                                                                <div className="flex justify-between items-between">
                                                                    <p className="text-eGray font-MontserratSemiBold">{item.vc_cliente}</p>
                                                                    <Rating>
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                    </Rating>
                                                                </div>
                                                                <p className="text-xs text-eGray py-5">{item.tx_resena}</p>
                                                            </div>
                                                            <p className="text-end text-sm">{new Date(item.created_at).getDate()}/{new Date(item.created_at).getMonth()}/{new Date(item.created_at).getFullYear()}</p>
                                                        </div>
                                                    : ""
                                                ))
                                            }
                                        </div>)
                                    }
                                    return options;
                                }
                            )()
                        }
                    </Carousel>

                    {/*1024 to 1280*/}
                    <Carousel
                        slideInterval={10000}
                        className="hidden sm:hidden md:hidden lg:block"
                        indicators={false}
                        leftControl={<div><img src={Prev} alt="Anterior" className="relative -left-14 w-20" /></div>}
                        rightControl={<div><img src={Next} alt="Siguiente" className="relative left-14 w-20" /></div>}
                    >
                        {
                            (
                                () => {
                                    const options = [];
                                    for (let i = 0; i < Math.ceil(resenas.length/4); i++) {
                                        options.push(<div key={i} className="flex">
                                            {
                                                resenas.map( (item, idx) => (
                                                    ( idx >= 4*i && idx < 4*(i+1) ) ?
                                                        <div key={idx} className="w-1/4 flex flex-col justify-between items-between bg-white m-2 p-5 h-[344px]">
                                                            <div>
                                                                <div className="flex justify-between items-between">
                                                                    <p className="text-eGray font-MontserratSemiBold">{item.vc_cliente}</p>
                                                                    <Rating>
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                        <Rating.Star />
                                                                    </Rating>
                                                                </div>
                                                                <p className="text-sm text-eGray py-5">{item.tx_resena}</p>
                                                            </div>
                                                            <p className="text-end text-sm">{new Date(item.created_at).getDate()}/{new Date(item.created_at).getMonth()}/{new Date(item.created_at).getFullYear()}</p>
                                                        </div>
                                                    : ""
                                                ))
                                            }
                                        </div>)
                                    }
                                    return options;
                                }
                            )()
                        }
                    </Carousel>
                </>
            ) }
        </ClientOnly>
    )
}

export default CarouselResenas
