import { Form, Link, useLocation } from "@remix-run/react"
import { Button, Navbar } from "flowbite-react"

import Logo from "../../public/assets/img/logo-menu.webp"
import Lupa from "../../public/assets/img/search-icon.webp"
import Cart from "../../public/assets/img/cart-icon.webp"
import { useState } from "react"

const Header = ({cantCarrito, cantCarritoMedida}) => {
    const location = useLocation()

    const [ buscar, setBuscar ] = useState("")

    const handleSubmit = e => {
        e.preventDefault()
        window.location.href="/productos?search="+buscar
    }

    return (
        <>
            <div className="sticky top-0 z-10">
                <Navbar
                    className="hidden md:block bg-eBlack py-7"
                    fluid={true}
                    rounded={false}
                >
                    <div className="flex lg:w-10/12 mx-auto">
                        <div className="w-3/12 flex justify-center items-center">
                            <Navbar.Brand href="/">
                                <img
                                    src={Logo}
                                    className="mr-3 h-6 sm:h-9"
                                    alt="Eversafe Logo"
                                />
                            </Navbar.Brand>
                        </div>
                        <div className="w-5/12 flex justify-center items-center">
                            <form onSubmit={e => handleSubmit(e)} noValidate>
                                <div className="flex">
                                    <input 
                                        type="text" 
                                        className="bg-transparent border-2 border-r-0 border-eGray rounded-l-full w-full font-MontserratRegular px-5 text-white"
                                        value={buscar}
                                        onChange={e => setBuscar(e.target.value)}
                                        placeholder="Encuentra tu puerta" />
                                    <Button className="!bg-transparent border-2 border-l-0 border-eGray rounded-r-full py-2" type="submit"><img src={Lupa} alt="Buscar" /></Button>
                                </div>
                            </form>
                        </div>
                        <div className="w-5/12 flex justify-end items-center">
                            <div className="flex justify-center items-center md:order-2">
                                {/*<div className="lg:flex justify-center items-center">
                                    <Button className="bg-transparent hover:bg-transparent rounded-r-full rounded-l-full font-MontserratRegular">
                                        Iniciar Sesión
                                    </Button>
                                    <Button className="bg-eYellow hover:bg-eYellow text-eBlack rounded-r-full rounded-l-full mx-4 font-MontserratRegular">
                                        Regístrate
                                    </Button>
                                </div>*/}
                                <Link to="/carrito"><img src={Cart} className="w-6 h-6 mr-2" alt="Carrito de compras" /></Link>
                                <span className="rounded-full font-MontserratRegular bg-eRed text-white text-sm px-1.5">{
                                    cantCarrito !== 0 ?
                                        cantCarrito 
                                    : cantCarritoMedida !== 0 ? 
                                        cantCarritoMedida 
                                    : 0
                                }</span>
                                <Navbar.Toggle />
                            </div>
                        </div>
                    </div>
                </Navbar>
                
                <Navbar
                    className="hidden md:block bg-eBlue sticky"
                    fluid={true}
                    rounded={false}
                >
                    <div className="mx-auto">
                        <Navbar.Collapse>
                            <Link
                                className={ `${location.pathname === '/puertas-a-medida' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                to="/puertas-a-medida"
                            >
                                Puertas a tu medida
                            </Link>
                            <Link 
                                className={ `${location.pathname === '/productos/seguridad' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                to="/productos/seguridad"
                            >
                                puertas de seguridad
                            </Link>
                            <Link 
                                className={ `${location.pathname === '/productos/acorazadas' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                to="/productos/acorazadas">
                                puertas acorazadas
                            </Link>
                            <Link 
                                className={ `${location.pathname === '/productos/antibalas' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                to="/productos/antibalas">
                                puerta balística
                            </Link>
                            <Navbar.Link 
                                className={ `${location.pathname === '/productos/deck' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                href="/productos/deck">
                                deck
                            </Navbar.Link>
                            <Navbar.Link 
                                className={ `${location.pathname === '/productos/piso-laminado' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                href="/productos/piso-laminado">
                                piso laminado
                            </Navbar.Link>
                            <Navbar.Link 
                                className={ `${location.pathname === '/productos/otros-productos' ? 'underline' : ''} text-white hover:!text-white uppercase font-MontserratRegular`}
                                href="/productos/otros-productos">
                                otros productos
                            </Navbar.Link>
                        </Navbar.Collapse>
                    </div>
                </Navbar>
            
                <Navbar
                    className="md:hidden bg-eBlack"
                    fluid={true}
                    rounded={false}
                >
                    <Navbar.Brand href="/">
                        <img
                            src={Logo}
                            className="h-6 sm:h-9"
                            alt="Eversafe Logo"
                        />
                    </Navbar.Brand>

                    <div className="flex justify-center items-center">
                        <Link to="/carrito"><img src={Cart} className="w-6 h-6 mr-2" alt="Carrito de compras" /></Link>
                        <span className="rounded-full font-MontserratRegular bg-eRed text-white text-sm px-1.5">{
                            cantCarrito !== 0 ?
                                cantCarrito 
                            : cantCarritoMedida !== 0 ? 
                                cantCarritoMedida 
                            : 0
                        }</span>
                    </div>
                    
                    <div className="flex md:order-2">
                        <Navbar.Toggle className="bg-eBlack" />
                    </div>
                    <Navbar.Collapse className="bg-eBlue">
                        <Link to="/puertas-a-medida" className="text-white hover:!text-white font-MontserratRegular text-end uppercase">
                            puertas a tu medida
                        </Link>
                        <Link 
                            to="/productos/seguridad" 
                            className={`${location.pathname === '/productos/seguridad' ? 'underline' : ''} text-white hover:!text-white font-MontserratRegular text-end uppercase`}>
                            puertas de seguridad
                        </Link>
                        <Link to="/productos/acorazadas" className={`${location.pathname === '/productos/acorazadas' ? 'underline' : ''} text-white hover:!text-white font-MontserratRegular text-end uppercase`}>
                            puertas acorazadas
                        </Link>
                        <Link to="/productos/antibalas" className={`${location.pathname === '/productos/antibalas' ? 'underline' : ''} text-white hover:!text-white font-MontserratRegular text-end uppercase`}>
                            puertas balísticas
                        </Link>
                        <Link href="/productos/deck" className={`${location.pathname === '/productos/deck' ? 'underline' : ''} text-white hover:!text-white font-MontserratRegular text-end uppercase`}>
                            deck
                        </Link>
                        <Link href="/productos/piso-laminado" className={`${location.pathname === '/productos/piso-laminado' ? 'underline' : ''} text-white hover:!text-white font-MontserratRegular text-end uppercase`}>
                            piso laminado
                        </Link>
                        <Link href="/productos/otros-productos" className={`${location.pathname === '/productos/otros-productos' ? 'underline' : ''} text-white hover:!text-white font-MontserratRegular text-end uppercase`}>
                            Otro productos
                        </Link>

                        <form onSubmit={e => handleSubmit(e)} noValidate>
                            <div className="flex mt-2 mx-2">
                                <input 
                                    type="text" 
                                    value={buscar}
                                    onChange={e => setBuscar(e.target.value)}
                                    className="bg-eBlack border-2 border-r-0 border-eGray rounded-l-full w-full font-MontserratRegular px-5 text-white"
                                    placeholder="Encuentra tu puerta" />
                                <Button className="bg-eBlack border-2 border-l-0 border-eGray rounded-r-full py-2" type="submit"><img src={Lupa} alt="Buscar" /></Button>
                            </div>
                        </form>

                        <div className="flex my-2 justify-around">
                            {/*<Button className="bg-eBlack rounded-r-full rounded-l-full font-MontserratRegular">
                                Iniciar Sesión
                            </Button>
                            <Button className="bg-eYellow rounded-r-full rounded-l-full font-MontserratRegular">
                                Registrate
                            </Button>*/}
                        </div>
                    </Navbar.Collapse>
                </Navbar>
            </div>
        </>
    )
}

export default Header
