import { useEffect, useState } from "react"

const ListaOpcionesCelosia = ({
    celosiaOptionsShow, 
    Empty,
    dataOpcionesCelosia, 
    configuracion, 
    setCelosiaBatiente, 
    setCelosiaPivote, 
    setCelosiaFijoAbatible, 
    setCelosiaDoble, baseUrl, puertaMedidaCarrito, setPuertaMedidaCarrito, design
}) => {
    const [ seleccion, setSeleccion ] = useState("")

    useEffect(() => {
        if (typeof dataOpcionesCelosia.length === 'undefined') {
            setSeleccion("")
        }
    }, [dataOpcionesCelosia])
    
    const loadOpcion = (batiente, pivote, fijoabatible, doble, id, precio_batiente, precio_pivote, precio_fijoabatible, precio_doble, elemento_nombre, preview) => {
        if( configuracion === "batiente" ) {
            setCelosiaBatiente(baseUrl+batiente)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textCelosia: id, textCelosiaPrecio: precio_batiente, textCelosiaImagen: preview, nombreCelosia: elemento_nombre })
        } else if( configuracion === "pivote" ) {
            setCelosiaPivote(baseUrl+pivote)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textCelosia: id, textCelosiaPrecio: precio_pivote, textCelosiaImagen: preview, nombreCelosia: elemento_nombre })
        } else if( configuracion === "fijoabatible" ) {
            setCelosiaFijoAbatible(baseUrl+fijoabatible)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textCelosia: id, textCelosiaPrecio: precio_fijoabatible, textCelosiaImagen: preview, nombreCelosia: elemento_nombre })
        } else if( configuracion === "doble" ) {
            setCelosiaDoble(baseUrl+doble)
            setSeleccion(id)
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textCelosia: id, textCelosiaPrecio: precio_doble, textCelosiaImagen: preview, nombreCelosia: elemento_nombre })
        }
    }

    const remove = () => {
        setPuertaMedidaCarrito({ ...puertaMedidaCarrito, textCelosia: "", textCelosiaPrecio: "", textCelosiaImagen: "", nombreCelosia: "" })
        
        setSeleccion("")
        setCelosiaBatiente(Empty)
        setCelosiaPivote(Empty)
        setCelosiaFijoAbatible(Empty)
        setCelosiaDoble(Empty)
    }

    return (
        <div className={`mt-5 flex ${design} gap-5 ${celosiaOptionsShow}`}>
            {
                dataOpcionesCelosia?.length ? (
                    dataOpcionesCelosia.map( opts => (
                        <div key={opts.id} className={`bg-white w-32 flex flex-col justify-center items-center px-2 py-5 ${opts.id === seleccion ? 'border-2 border-solid border-eYellow' : ''}`}>
                            <img src={baseUrl+opts.vc_img_preview} alt="Celosia" className="w-full mb-3" />
                            <p className="w-full text-center text-eGray font-MontserratRegular text-sm">{opts.vc_nombre}</p>
                            {
                                ( configuracion === "batiente") ? 
                                    <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_batiente}</p> 
                                : 
                                    ( configuracion === "pivote") ? 
                                        <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_pivote}</p> 
                                    : 
                                        ( configuracion === "fijoabatible") ? 
                                            <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_batiente_fijo}</p> 
                                                : 
                                                    ( configuracion === "doble") ? 
                                                        <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio_doble}</p> 
                                                            : 
                                                                "No hay opciones"
                            }
                            {
                                opts.id === seleccion ? <button onClick={() => remove()} className="mt-5 bg-eLightGray text-eGray text-sm px-4 py-1 rounded-full">Remover</button>
                                : <button onClick={() => loadOpcion(opts.vc_img_batiente, opts.vc_img_pivote, opts.vc_img_batiente_fijo, opts.vc_img_doble, opts.id, opts.f_precio_batiente, opts.f_precio_pivote, opts.f_precio_batiente_fijo, opts.f_precio_doble, opts.vc_nombre, opts.vc_img_preview)} className="mt-5 bg-eYellow text-eGray text-sm px-4 py-1 rounded-full">Agregar</button>
                            }
                        </div>
                    ))
                ) : "No hay opciones de diseño"
            }
        </div>
    )
}

export default ListaOpcionesCelosia