import { Link } from "@remix-run/react"
import { ClientOnly } from "remix-utils"
import GoBlack from "../../public/assets/img/go-icon-black.webp"

const SliderDos = ({banners, baseUrl}) => {
    return (
        <ClientOnly fallback={''}>
        { 
            () => (
                <>
                    <div id="carouselExampleCaptions" className="hidden sm:block relative" data-te-carousel-init data-te-carousel-slide>
                        <div className="absolute bottom-0 sm:-bottom-2 md:bottom-0 sm:-left-20 md:-left-20 lg:-left-24 z-[2] mx-[15%] mb-4 flex list-none justify-center p-0" data-te-carousel-indicators>
                            {
                                banners.map( (item, idx) => (
                                    <button key={idx} type="button" data-te-target="#carouselExampleCaptions" data-te-slide-to={idx} data-te-carousel-active={idx === 0 ? true : false} className="mx-[3px] box-content h-[3px] w-[60px] lg:w-[100px] flex-initial cursor-pointer border-0 border-y-[10px] border-solid border-transparent bg-eGray aria-current:bg-eBlue bg-clip-padding p-0 -indent-[999px] transition-opacity duration-[600ms] ease-[cubic-bezier(0.25,0.1,0.25,1.0)] motion-reduce:transition-none" aria-current={idx === 0 ? true : false} aria-label={`Slide ${idx+1}`}></button> 
                                ))
                            }
                        </div>
                        <div className="relative w-full overflow-hidden after:clear-both after:block after:content-['']"> 
                            {
                                banners.map( (item, idx) => (
                                    idx === 0 ?
                                        <div key={idx} className="relative float-left -mr-[100%] w-full transition-transform duration-[600ms] ease-in-out motion-reduce:transition-none" data-te-carousel-active={idx===0 ? true : false} data-te-carousel-item>
                                            <a href={item.vc_link} target="_blank">
                                                <img src={baseUrl+item["vc_img_desktop"]} className="block w-full" alt="..." />
                                                <div className="absolute hidden sm:block top-0 left-0 sm:top-2 sm:left-5 md:top-6 md:left-10 lg:top-10 lg:left-20 xl:top-20 xl:left-28 z-0">
                                                    
                                                </div>    
                                            </a>
                                        </div>
                                    :
                                    <div key={idx} className="relative float-left -mr-[100%] hidden w-full transition-transform duration-[600ms] ease-in-out motion-reduce:transition-none" data-te-carousel-item>
                                        <a href={item.vc_link} target="_blank">
                                            <img src={baseUrl+item["vc_img_desktop"]} className="block w-full" alt="..." />
                                            <div className="absolute inset-x-[15%] bottom-5 hidden py-5 text-center text-white md:block">
                                                
                                            </div>
                                        </a>
                                    </div>
                                ))
                            }
                        </div>
                    </div>

                    <div id="carouselExampleCaptionsMobile" className="sm:hidden relative" data-te-carousel-init data-te-carousel-slide>
                        <div className="absolute right-0 bottom-0 left-0 z-[2] mx-[15%] mb-4 flex list-none justify-center p-0" data-te-carousel-indicators>
                            {
                                banners.map( (item, idx) => (
                                    <button key={idx} type="button" data-te-target="#carouselExampleCaptionsMobile" data-te-slide-to={idx} data-te-carousel-active={idx === 0 ? true : false} className="mx-[3px] box-content h-[3px] w-[60px] lg:w-[100px] flex-initial cursor-pointer border-0 border-y-[10px] border-solid border-transparent bg-eGray aria-current:bg-eBlue bg-clip-padding p-0 -indent-[999px] transition-opacity duration-[600ms] ease-[cubic-bezier(0.25,0.1,0.25,1.0)] motion-reduce:transition-none" aria-current={idx === 0 ? true : false} aria-label={`Slide ${idx+1}`}></button>                                ))
                            }
                        </div>
                        <div className="relative w-full overflow-hidden after:clear-both after:block after:content-['']"> 
                            {
                                banners.map( (item, idx) => (
                                    idx === 0 ?
                                        <div key={idx} className="relative float-left -mr-[100%] w-full transition-transform duration-[600ms] ease-in-out motion-reduce:transition-none" data-te-carousel-active={idx===0 ? true : false} data-te-carousel-item>
                                            <img src={baseUrl+item["vc_img_mobile"]} className="block w-full" alt="..." />
                                            <div className="absolute top-0 left-0 z-0 pl-5 pt-3 pr-5">
                                                
                                            </div>
                                        </div>
                                    :
                                    <div key={idx} className="relative float-left -mr-[100%] hidden w-full transition-transform duration-[600ms] ease-in-out motion-reduce:transition-none" data-te-carousel-item>
                                        <img src={baseUrl+item["vc_img_mobile"]} className="block w-full" alt="..." />
                                        <div className="absolute inset-x-[15%] bottom-5 hidden py-5 text-center text-white md:block">
                                            
                                        </div>
                                    </div>
                                ))
                            }
                        </div>
                    </div>

                </>
            ) 
        }
        </ClientOnly>
    )
}

export default SliderDos