import { Link, Form, useLoaderData, useOutletContext } from "@remix-run/react"
import { ClientOnly } from "remix-utils"

import SatisfaccionGarantizada from "~/components/satisfacciongarantizada"
import CarouselMasVendidos from "~/components/carouselmasvendidos"
import { getPuertasCarousel } from "~/models/galerias.server"
import { getPuertaUrl, getProductoUrl } from "~/models/productos.server"
import { numberWithCommas } from "~/helpers/functions"

import BackArrow from "../../public/assets/img/back-icon.webp"
import CheckGreen from "../../public/assets/img/check-icon-green.webp"
import Delete from "../../public/assets/img/quitar-icon.webp"
import CheckYellow from "../../public/assets/img/check-icon2.webp"
import { useState, useEffect } from "react"

export async function loader() {
    const [ carousel, puertas, productos ] = await Promise.all( [ getPuertasCarousel(), getPuertaUrl(), getProductoUrl() ] )
    loaderData = {
		carousel: carousel.data,
        puertas: puertas.data, 
        productos: productos.data, 
        baseUrl: process.env.WEB_URL
        
    }
    return loaderData
}

const Carrito = () => {
    const loadedData = useLoaderData()
    const { carousel, baseUrl } = loadedData
    const [ total, setTotal ] = useState(0)
    const [ promociones, setPromociones ] = useState(0.00)
    const { carrito, actualizarCantidad, eliminarPuerta, eliminarSmart, carritoMedida, eliminarPuertaMedida, cpEntrega, setCpEntrega } = useOutletContext()

    useEffect( () => {
        // console.log(carrito)
        const calculotTotal = carrito?.reduce( (total, producto) => total + (producto.cantidad * Number(producto.precio.replace(",",""))), 0 )

        let totalSmart = 0
        carrito.forEach( item => {
            typeof item.smart.f_precio !== 'undefined' ?
                totalSmart = totalSmart + (Number(item.smart.f_precio.replace(",",""))*item.cantidad)
            : ""
        })

        const totalPromociones = carrito?.reduce( (total, producto) => total + ((producto.cantidad * Number(producto.precio.replace(",","")))*(producto.descuento/100)), 0 )

        let totalPromocionesSmart = 0
        carrito.forEach( item => {
            typeof item.smart.f_precio !== 'undefined' ?
                totalPromocionesSmart = totalPromocionesSmart + (Number(item.smart.f_precio.replace(",",""))*((item.smart.i_descuento/100))*item.cantidad)
            : ""
        })

        setPromociones(totalPromociones+totalPromocionesSmart)
        
        setTotal((calculotTotal+totalSmart).toFixed(2))
    }, [carrito])

    useEffect( () => {
        if( carritoMedida.length >= 14 && carrito.length === 0 ) {
            if ( +carritoMedida[15].mecanismo === 8 ) {
                setTotal(+carritoMedida[13].totalPuertaMedida+650)
            } else {
                setTotal(carritoMedida[13].totalPuertaMedida)
            }
        }
    }, [carritoMedida])

    return (
        <ClientOnly fallback={'Cargando...'}>
            { () => (
                <div className="bg-eLightGray pb-20">
                    <section className="lg:flex mb-10">
                        <div className="lg:w-8/12 py-20 px-2 sm:px-10 bg-white">
                            <div className="lg:flex gap-3 justify-center lg:justify-between items-center">
                                <p className="text-eBlack font-MontserratBold text-center lg:text-start text-2xl">Carrito de compras</p>
                                <div className="flex justify-center items-center gap-2">
                                    <img src={BackArrow} alt="Regresar a productos" />
                                    <Link to="/productos" className="text-eBlue font-MontserratRegular">Seguir comprando</Link>
                                </div>
                            </div>

                            <hr className="my-5" />

                            {
                                carrito?.length !== 0 ? (
                                    carrito?.map( producto => (
                                        <div key={producto.id} className="lg:flex py-10 border-b-2">
                                            <div className="lg:w-2/12">
                                                <img src={baseUrl+producto.imagen} alt="Puerta Cartegena" />
                                            </div>
                                            <div className="lg:w-10/12">
                                                <div className="lg:flex flex-col">
                                                    <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                        <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{producto.puerta} {producto.modelo}</p>
                                                        <div>
                                                            {
                                                                producto.descuento > 0 ?
                                                                    <>
                                                                        <p className="font-MontserratSemiBold line-through text-eGray text-xl text-center lg:text-start">${producto.precio}</p>
                                                                        <p className="font-MontserratSemiBold text-[#e03e2d] text-xl text-center lg:text-start">
                                                                            {
                                                                                Intl.NumberFormat('es-MX',{style:'currency',currency:'MXN'}).format(parseFloat(producto.precio.replace(",","")) - (parseFloat(producto.precio.replace(",","")) * parseFloat(producto.descuento/100)))
                                                                            }
                                                                        </p>
                                                                    </>
                                                                : 
                                                                    <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${producto.precio}</p>
                                                            }
                                                        </div>
                                                    </div>
                                                    <div className="w-full lg:flex justify-between items-center mt-5">
                                                        <div className="lg:pr-20">
                                                            <div className="post__content" dangerouslySetInnerHTML={{__html: producto.descripcion}}></div>
                                                        </div>
                                                        <div className="flex gap-2 justify-center items-center mt-5 lg:mt-0">
                                                            <img src={CheckGreen} alt="Disponivle" />
                                                            <p className="font-MontserratRegular text-eGreen">Disponible</p>
                                                        </div>
                                                    </div>
                                                    <div className="lg:flex gap-2 mt-10">
                                                        <div className="lg:w-5/12">
                                                        </div>
                                                        <div className="lg:w-4/12 mt-5 lg:mt-0">
                                                            <label htmlFor="cobertura" className="font-MontserratRegular text-sm">Cobertura de envío:</label>
                                                            <Form className="">
                                                                <div className="flex "> 
                                                                    <input 
                                                                        id="cobertura" 
                                                                        type="text"
                                                                        value={cpEntrega}
                                                                        onChange={ e => setCpEntrega(e.target.value) } 
                                                                        placeholder="CÓDIGO POSTAL" 
                                                                        className="focus:border-eYellow mt-2 focus:ring-0 h-12 border-2 border-eGray rounded-md w-full" />
                                                                        {/*className="focus:border-eYellow mt-2 focus:ring-0 h-12 border-2 border-r-0 border-eGray rounded-l-md w-full" />
                                                                        <button className="bg-white border-2 border-l-0 border-eGray focus:ring-0 mt-2 rounded-r-md h-12" type="submit">
                                                                            <p className="underline pr-2">Cambiar</p>
                                                                        </button>*/}
                                                                </div>
                                                            </Form>
                                                        </div>
                                                        <div className="flex justify-center items-center lg:justify-end lg:items-end lg:w-3/12 mt-5 lg:mt-0">
                                                            <input 
                                                                type="text" 
                                                                value={producto.cantidad} 
                                                                onChange={ e => actualizarCantidad({
                                                                    cantidad: +e.target.value,
                                                                    id: producto.id
                                                                })}
                                                                className="w-20 focus:border-eYellow focus:ring-0 text-center border-2 border-eGray rounded-l-md font-MontserratBold h-12" 
                                                            />
                                                            <div className="flex flex-col">
                                                                <button onClick={ () => actualizarCantidad({
                                                                    cantidad: producto.cantidad+1,
                                                                    id: producto.id
                                                                })} className="bg-eBlack text-white text-sm font-MontserratRegular border-0 px-3 py-0.5 rounded-tr-md" type="button">^</button>
                                                                <button onClick={ e => actualizarCantidad({
                                                                    cantidad: producto.cantidad-1,
                                                                    id: producto.id
                                                                })} className="bg-eBlack text-white text-sm font-MontserratRegular border-0 px-3 py-0.5 rounded-tl-md rotate-180" type="button">^</button>
                                                            </div>
                                                        </div>
                                                        <div className="flex justify-center items-center lg:justify-end lg:items-end lg:w-4/12">
                                                            <div className="flex gap-2 justify-center items-center h-12">
                                                                <img src={Delete} alt="Eliminar" />
                                                                <button 
                                                                    type="button"
                                                                    onClick={ () => eliminarPuerta(producto.id)} 
                                                                    className="underline"
                                                                >
                                                                    Quitar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {
                                                    typeof producto.smart.id === 'undefined' ?
                                                        ""
                                                    :
                                                        <div className="border-2 border-eYellow p-5 mt-10">
                                                            <div className="lg:flex">
                                                                <div className="lg:w-2/12 flex justify-center items-center">
                                                                    <img src={baseUrl+producto.smart.vc_imagen} alt="Cerradura" />
                                                                </div>
                                                                <div className="lg:w-5/12 flex flex-col justify-center items-center lg:justify-center lg:items-start mt-5 lg:mt-0">
                                                                    <p className="text-eGray font-MontserratRegular uppercase">{producto.smart.vc_producto}</p>
                                                                    <p className="text-eGray font-MontserratSemiBold">+ ${producto.smart.f_precio}</p>
                                                                </div>
                                                                <div className="flex justify-center items-center gap-2 lg:w-3/12 my-5 lg:my-0">
                                                                    <img src={CheckYellow} alt="Agregado" />
                                                                    <p className="font-MontserratRegular text-eYellow text-sm uppercase">agregado a tu compra</p>
                                                                </div>
                                                                <div className="flex justify-center items-center gap-2 lg:w-2/12">
                                                                    <img src={Delete} alt="Eliminar" />
                                                                    <button 
                                                                        type="button"
                                                                        onClick={ () => eliminarSmart(producto.id)} 
                                                                        className="underline"
                                                                    >
                                                                        Quitar
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                }
                                                
                                            </div>
                                        </div>
                                    ))
                                ) : carritoMedida?.length >= 14 ? (
                                    <div>
                                        <div className="flex justify-end items-end lg:justify-end lg:items-end w-12/12">
                                            <div className="flex gap-2 justify-center items-center h-12">
                                                <img src={Delete} alt="Eliminar" />
                                                <button 
                                                    type="button"
                                                    onClick={ () => eliminarPuertaMedida(carritoMedida[0].id)} 
                                                    className="underline"
                                                >
                                                    Quitar
                                                </button>
                                            </div>
                                        </div>

                                        <div className={`flex justify-center items-end pb-10`}>
                                            <div className="relative w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]">
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[0].textura} alt="Textura" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[1].armazon} alt="Armazon" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[2].diseno} alt="Diseño" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[3].cristal} alt="Cristal" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[4].celosia} alt="Celosia" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[5].maneral} alt="Maneral" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[6].manija} alt="Manija" />
                                                </div>
                                                <div className={`absolute top-0 left-0 w-[320px] h-[320px] sm:w-[600px] sm:h-[600px]`}>
                                                    <img src={carritoMedida[14].imageFinal[7].fijos} alt="Fijos" />
                                                </div>
                                            </div>
                                        </div>

                                        <div className="flex border">
                                            <div className="w-full p-5 border-x">
                                                Datos generales
                                            </div>
                                        </div>

                                        <div className="flex border">
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                {/*<p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Vano ancho: <span className="text-eGray font-MontserratRegular">{carritoMedida[1].vanoAncho} cms</span></p>
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Vano alto: <span className="text-eGray font-MontserratRegular">{carritoMedida[1].vanoAlto} cms</span></p>*/}
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Puerta ancho: <span className="text-eGray font-MontserratRegular">{carritoMedida[1].puertaAncho} cms</span></p>
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Puerta alto: <span className="text-eGray font-MontserratRegular">{carritoMedida[1].puertaAlto} cms</span></p>
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Chambrana: <span className="text-eGray font-MontserratRegular">{carritoMedida[15].chambrana}</span></p>
                                            </div>
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Tipo de puerta: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[2].opcionPuerta}</span></p>
                                                { 
                                                    carritoMedida[2].anchofijoabatible !== "" ?
                                                        <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Medida de fijo: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[2].anchofijoabatible} cms</span></p>
                                                    : ""
                                                }
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Apertura: 
                                                    <span className="text-eGray font-MontserratRegular uppercase">
                                                        {
                                                            carritoMedida[12].apertura === "intDer" ?
                                                                "interior derecha"
                                                            : carritoMedida[12].apertura === "intIzq" ?
                                                                "interior izquierda"
                                                            : carritoMedida[12].apertura === "extDer" ?
                                                                "exterior derecha"
                                                            : carritoMedida[12].apertura === "extIzq" ?
                                                                "exterior izquierda"
                                                            : ""
                                                        }
                                                    </span>
                                                </p>
                                            </div>
                                        </div>

                                        <br />
                                        <div className="flex border">
                                            <div className="w-full p-5 border-x">
                                                Datos generales
                                            </div>
                                        </div>

                                        <div className="flex border">
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Chambrana: </p>
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Mirilla: </p>
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Cubrepolvo: </p>
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Mecanismo: </p>
                                            </div>
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p><span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[15].chambrana}</span></p>
                                                <p><span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[15].mirilla}</span></p>
                                                <p><span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[15].cubrepolvo}</span></p>
                                                <p><span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[15].mecanismo} pernos</span></p>
                                            </div>
                                        </div>

                                        <br />

                                        <div className="flex border">
                                            <div className="w-6/12 p-2 sm:p-5 border-x text-xs sm:text-sm md:text-base">Descripción</div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x text-xs sm:text-sm md:text-base">Imagen</div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x text-xs sm:text-sm md:text-base">Precio</div>
                                        </div>

                                        <div className="flex border"> {/** Configuración */}
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Configuración: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[3].configuracionFijo}</span></p>
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                {
                                                    carritoMedida[3].configuracionFijo !== "x" ? <img src={baseUrl+carritoMedida[3].configuracionFijoImagen} alt={carritoMedida[3].configuracionFijo} /> : ""
                                                }        
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                {
                                                    carritoMedida[3].configuracionFijo !== "x" ? <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[3].configuracionFijoPrecio)}</p> : ""
                                                }
                                            </div>
                                        </div>

                                        <div className="flex border"> {/** Textura exterior */}
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Textura exterior: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[4].nombreTexturaExterior}</span> </p>
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                <img src={baseUrl+carritoMedida[4].texturaExteriorImagen} alt="Textura exterior" />
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[4].texturaExteriorPrecio)}</p>
                                            </div>
                                        </div>

                                        <div className="flex border"> {/** Textura interior */}
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Textura interior: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[5].nombreTexturaInterior}</span> </p>
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                <img src={baseUrl+carritoMedida[5].textInteriorImagen} alt="Textura interior" />
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[5].textInteriorPrecio)}</p>
                                            </div>
                                        </div>

                                        <div className="flex border"> {/** Manija */}
                                            <div className="w-6/12 p-2 sm:p-5 border-x">
                                                <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Manija: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[11].nombreManija}</span></p>
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                <img src={baseUrl+carritoMedida[11].textManijaImagen} alt="Manija" />
                                            </div>
                                            <div className="w-3/12 p-1 sm:p-5 border-x">
                                                <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[6].textArmazonPrecio)}</p>
                                            </div>
                                        </div>

                                        {
                                            carritoMedida[7].textDiseno !== "" ?
                                                <div className="flex border"> {/** Diseño */}
                                                    <div className="w-6/12 p-2 sm:p-5 border-x">
                                                        <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Diseño: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[7].nombreDiseno}</span></p>
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <img src={baseUrl+carritoMedida[7].textDisenoImagen} alt="Manija" />
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[7].textDisenoPrecio)}</p>
                                                    </div>
                                                </div>
                                            : ""
                                        }

                                        {
                                            carritoMedida[8].textCristal !== "" ?
                                                <div className="flex border"> {/** Cristal */}
                                                    <div className="w-6/12 p-2 sm:p-5 border-x">
                                                        <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Cristal: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[8].nombreCristal}</span></p>
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <img src={baseUrl+carritoMedida[8].textCristalImagen} alt="Manija" />
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[8].textCristalPrecio)}</p>
                                                    </div>
                                                </div>
                                            : ""
                                        }

                                        {
                                            carritoMedida[9].textCelosia !== "" ?
                                                <div className="flex border"> {/** Celosia */}
                                                    <div className="w-6/12 p-2 sm:p-5 border-x">
                                                        <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Celosia: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[9].nombreCelosia}</span></p>
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <img src={baseUrl+carritoMedida[9].textCelosiaImagen} alt="Manija" />
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[9].textCelosiaPrecio)}</p>
                                                    </div>
                                                </div>
                                            : ""
                                        }

                                        {
                                            carritoMedida[10].textManeral !== "" ?
                                                <div className="flex border"> {/** Maneral */}
                                                    <div className="w-6/12 p-2 sm:p-5 border-x">
                                                        <p className="text-eGray font-MontserratBold text-xs sm:text-sm md:text-base">Maneral: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[10].nombreManeral}</span></p>
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <img src={baseUrl+carritoMedida[10].textManeralImagen} alt="Manija" />
                                                    </div>
                                                    <div className="w-3/12 p-1 sm:p-5 border-x">
                                                        <p className="font-MontserratSemiBold text-eGray text-xs sm:text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[10].textManeralPrecio)}</p>
                                                    </div>
                                                </div>
                                            : ""
                                        }
                                        


                                        {/*<div className="lg:flex py-2 ">
                                            <div className="w-full">
                                                <p className="text-eGray font-MontserratBold">Configuración: <span className="text-eGray font-MontserratRegular uppercase">{carritoMedida[3].configuracionFijo}</span></p>
                                                <div className="lg:flex justify-center items-center">
                                                    <div className="lg:w-2/12">
                                                        {
                                                            carritoMedida[3].configuracionFijo !== "x" ? <img src={baseUrl+carritoMedida[3].configuracionFijoImagen} alt={carritoMedida[3].configuracionFijo} /> : ""
                                                        }                                                        
                                                    </div>
                                                    <div className="lg:w-10/12">
                                                        <div className="lg:flex flex-col">
                                                            <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start"></p>
                                                                <div>
                                                                    {
                                                                        carritoMedida[3].configuracionFijo !== "x" ? <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[3].configuracionFijoPrecio)}</p> : ""
                                                                    }
                                                                </div>
                                                            </div>
                                                        </div>                                                   
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div className="lg:flex py-2 ">
                                            <div className="w-full">
                                                <p className="text-eGray font-MontserratBold">Textura exterior: </p>
                                                <div className="lg:flex justify-center items-center">
                                                    <div className="lg:w-2/12">
                                                        <img src={baseUrl+carritoMedida[4].texturaExteriorImagen} alt="Textura exterior" />
                                                    </div>
                                                    <div className="lg:w-10/12">
                                                        <div className="lg:flex flex-col">
                                                            <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[4].nombre}</p>
                                                                <div>
                                                                    <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[4].texturaExteriorPrecio)}</p>
                                                                </div>
                                                            </div>
                                                        </div>                                                   
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div className="lg:flex py-2 ">
                                            <div className="w-full">
                                                <p className="text-eGray font-MontserratBold">Textura interior: </p>
                                                <div className="lg:flex justify-center items-center">
                                                    <div className="lg:w-2/12">
                                                        <img src={baseUrl+carritoMedida[5].textInteriorImagen} alt="Textura exterior" />
                                                    </div>
                                                    <div className="lg:w-10/12">
                                                        <div className="lg:flex flex-col">
                                                            <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[5].nombre}</p>
                                                                <div>
                                                                    <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[5].textInteriorPrecio)}</p>
                                                                </div>
                                                            </div>
                                                        </div>                                                   
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div className="lg:flex py-2 ">
                                            <div className="w-full">
                                                    <p className="text-eGray font-MontserratBold">Armazón: </p>
                                                <div className="lg:flex justify-center items-center">
                                                    <div className="lg:w-2/12">
                                                        <img src={baseUrl+carritoMedida[6].textArmazonImagen} alt="Textura exterior" />
                                                    </div>
                                                    <div className="lg:w-10/12">
                                                        <div className="lg:flex flex-col">
                                                            <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[6].nombre}</p>
                                                                <div>
                                                                    <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[6].textArmazonPrecio)}</p>
                                                                </div>
                                                            </div>
                                                        </div>                                                   
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div className="lg:flex py-2 border-b-2">
                                            <div className="w-full">
                                                <p className="text-eGray font-MontserratBold">Manija: </p>
                                                <div className="lg:flex justify-center items-center">
                                                    <div className="lg:w-2/12">
                                                        <img src={baseUrl+carritoMedida[11].textManijaImagen} alt="Textura exterior" />
                                                    </div>
                                                    <div className="lg:w-10/12">
                                                        <div className="lg:flex flex-col">
                                                            <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[11].nombre}</p>
                                                                <div>
                                                                    <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[11].textManijaPrecio)}</p>
                                                                </div>
                                                            </div>
                                                        </div>                                                   
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {
                                            carritoMedida[7].textDiseno !== "" ?
                                                <div className="lg:flex py-2 ">
                                                    <div className="w-full">
                                                        <p className="text-eGray font-MontserratBold">Diseno: </p>
                                                        <div className="lg:flex justify-center items-center">
                                                            <div className="lg:w-2/12">
                                                                <img src={baseUrl+carritoMedida[7].textDisenoImagen} alt="Textura exterior" />
                                                            </div>
                                                            <div className="lg:w-10/12">
                                                                <div className="lg:flex flex-col">
                                                                    <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                        <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[7].nombre}</p>
                                                                        <div>
                                                                            <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[7].textDisenoPrecio)}</p>
                                                                        </div>
                                                                    </div>
                                                                </div>                                                   
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            : ""
                                        }
                                        {
                                            carritoMedida[8].textCristal !== "" ?
                                                <div className="lg:flex py-2 ">
                                                    <div className="w-full">
                                                        <p className="text-eGray font-MontserratBold">Cristal: </p>
                                                        <div className="lg:flex justify-center items-center">
                                                            <div className="lg:w-2/12">
                                                                <img src={baseUrl+carritoMedida[8].textCristalImagen} alt="Textura exterior" />
                                                            </div>
                                                            <div className="lg:w-10/12">
                                                                <div className="lg:flex flex-col">
                                                                    <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                        <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[8].nombre}</p>
                                                                        <div>
                                                                            <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[8].textCristalPrecio)}</p>
                                                                        </div>
                                                                    </div>
                                                                </div>                                                   
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            : ""
                                        }
                                        {
                                            carritoMedida[9].textCelosia !== "" ?
                                                <div className="lg:flex py-2 ">
                                                    <div className="w-full">
                                                        <p className="text-eGray font-MontserratBold">Celosia: </p>
                                                        <div className="lg:flex justify-center items-center">
                                                            <div className="lg:w-2/12">
                                                                <img src={baseUrl+carritoMedida[9].textCelosiaImagen} alt="Textura exterior" />
                                                            </div>
                                                            <div className="lg:w-10/12">
                                                                <div className="lg:flex flex-col">
                                                                    <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                        <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[9].nombre}</p>
                                                                        <div>
                                                                            <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[9].textCelosiaPrecio)}</p>
                                                                        </div>
                                                                    </div>
                                                                </div>                                                   
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            : ""
                                        }
                                        {
                                            carritoMedida[10].textManeral !== "" ?
                                                <div className="lg:flex py-2 ">
                                                    <div className="w-full">
                                                        <p className="text-eGray font-MontserratBold">Maneral: </p>
                                                        <div className="lg:flex justify-center items-center">
                                                            <div className="lg:w-2/12">
                                                                <img src={baseUrl+carritoMedida[10].textManeralImagen} alt="Textura exterior" />
                                                            </div>
                                                            <div className="lg:w-10/12">
                                                                <div className="lg:flex flex-col">
                                                                    <div className="w-full flex flex-col lg:flex-row gap-3  justify-center items-center lg:justify-between lg:items-start">
                                                                        <p className="font-MontserratSemiBold text-eGray text-2xl uppercase text-center lg:text-start">{carritoMedida[10].nombre}</p>
                                                                        <div>
                                                                            <p className="font-MontserratSemiBold text-eGray text-xl text-center lg:text-start">${numberWithCommas(carritoMedida[10].textManeralPrecio)}</p>
                                                                        </div>
                                                                    </div>
                                                                </div>                                                   
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            : ""
                                        }*/}

                                        <div className="mt-10">
                                            <p className="font-MontserratSemiBold text-xs">Notas importantes</p>
                                            {/*<p className="font-MontserratLight text-xs"><br /> * Cotización valida solo en el período del mes presente</p>
                                            <p className="font-MontserratLight text-xs"> * El proyecto solo incluye los artículos cotizados en la tabla anterior, no se incluyen acabados o modificaciones adicionales</p>*/}
                                            <p className="font-MontserratLight text-xs"> * Las imágenes aquí presentadas en los renders son una representación para referencia del cliente, sin embargo el proyecto final se revisa durante la visita técnica, por lo cual pueden presentarse ligeras variaciones.</p>
                                            <p className="font-MontserratLight text-xs"> * Precios en pesos mexicanos, Precios sujetos a IVA del 16%.</p>
                                            <p className="font-MontserratLight text-xs"> * Tiempo de entrega es de 5 a 7 días para puertas de línea, y en puertas a medida es de 45 días.</p>
                                            <p className="font-MontserratLight text-xs"> * Entrega e instalación en domicilio del cliente.</p>
                                            <p className="font-MontserratLight text-xs"> * En el caso de requerir factura favor de solicitarla a su asesor comercial después de su pago.</p>
                                            {/*<p className="font-MontserratLight text-xs"><br /> * Posterior a dar el primer pago de anticipo, todo cambio o agregado en el proyecto generará costo adicional. Es importante que durante las visitas técnicas y la instalación del proyecto se encuentre una persona responsable, que pueda tomar decisiones y que conozca perfectamente el proyecto. Todos nuestros productos cuentan con un año de garantía por defecto de fabricación, para cualquier necesidad de servicio técnico o garantía favor de comunicarse al numero de contacto Eversafe.</p>*/}
                                        </div>
                                    </div>
                                ) : "No hay elementos"
                            }
                            
                        </div>
                        <div className="lg:w-4/12 bg-eLightGray py-10 lg:py-20 px-10">
                            <p className="text-2xl font-MontserratSemiBold text-eGray">Resumen:</p>
                            <hr className="my-5" />
                            <div className="flex justify-between items-center my-10">
                                <p>Subtotal:</p>
                                <p className="font-MontserratSemiBold text-eGray">${numberWithCommas(Number(total).toFixed(2))}</p>
                            </div>
                            <div className="flex justify-between items-center my-10">
                                <p>Entrega:</p>
                                <p className="font-MontserratSemiBold text-eGray">$000.00</p>
                            </div>
                            <div className="flex justify-between items-center my-10">
                                <p>Promociones:</p>
                                <p className="font-MontserratSemiBold text-eGray">$-{numberWithCommas(promociones.toFixed(2))}</p>
                            </div>
                            <hr className="my-10" />
                            <div className="flex justify-between items-center">
                                <p className="font-MontserratSemiBold text-eGray uppercase">total:</p>
                                <div className="flex justify-center items-center gap-2">
                                    <span className="text-sm">MXN</span>
                                    <p className="font-MontserratSemiBold text-eGray">${numberWithCommas((total-promociones).toFixed(2))}</p>
                                </div>
                            </div>
                            <div className="flex justify-center items-center mt-12">
                                <Link to="/checkout" className="bg-eYellow text-eGray font-MontserratSemiBold px-10 py-3 rounded-md">Ir a caja</Link>
                            </div>
                        </div>
                    </section>

                    <SatisfaccionGarantizada />

                    <section className="containter w-10/12 mx-auto ">
                        <div className="flex flex-col lg:flex-row gap-3 lg:justify-between lg:items-center mb-10">
                            <div>
                                <p className="text-2xl text-eBlack font-MontserratRegular">Productos que pueden interesarte</p>
                            </div>
                            <div>
                                <Link to="#" className="text-xl text-eBlack font-MontserratRegular underline uppercase">ver todos</Link>
                            </div>
                        </div>

                        <div className="h-96">
                            <CarouselMasVendidos 
                                carousel={carousel}
                                baseUrl={baseUrl}
                            />
                        </div>
                    </section>
                </div>
            ) }
        </ClientOnly>
    )
}

export default Carrito
