import { Link, useLoaderData } from "@remix-run/react"
import { getPuertasCarousel } from "~/models/galerias.server"
import { getBannersHome, getResenas } from "~/models/home.server"
import Contacto from "../components/contacto"
import CarouselMasVendidos from "~/components/carouselmasvendidos"
import CarouselPromociones from "../components/carouselpromociones"
import CarouselResenas from "../components/carouselresenas"
import PersonalizaTuPuerta from "~/components/personalizatupuerta"
import SatisfaccionGarantizada from "~/components/satisfacciongarantizada"
import SliderDos from "~/components/sliderdos"

import GoProductos from "../../public/assets/img/go-icon-producto.webp"
import PuertasSeguridad from "../../public/assets/img/img-prod1.webp"
import PuertasAcorazadas from "../../public/assets/img/img-prod2.webp"
import PuertasAntiBalas from "../../public/assets/img/img-prod3.webp"
import PuertasDeck from "../../public/assets/img/img-prod4.webp"
import Alarmas from "../../public/assets/img/img-prod5.webp"
import Cerraduras from "../../public/assets/img/img-prod6.webp"
import Cintillo1 from "../../public/assets/img/cintillo1.webp"
import Cintillo2 from "../../public/assets/img/cintillo2.webp"
import styles from "../styles/main.css"

export async function loader() {
    const [ banners, carousel, resenas ] = await Promise.all( [ getBannersHome(), getPuertasCarousel(), getResenas() ] )
	console.log(banners)
    loaderData = {
        banners: banners.data, 
		carousel: carousel.data,
		resenas: resenas.data, 
		baseUrl: process.env.WEB_URL, 
		baseUrlApi: process.env.API_URL
    }
    return loaderData
}

export function links() {
    return [
        {
            rel: 'stylesheet',
            href: styles
        }
    ]
}

function Index() {
	const loadedData = useLoaderData()
    const { banners, carousel, resenas, baseUrl, baseUrlApi } = loadedData
	return (
		<>	
			<SliderDos 
				banners={banners}
				baseUrl={baseUrl}
			/>

			<section className="w-10/12 mx-auto py-0 sm:py-10 mt-10 mb-10 sm:mb-0">
				<div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
					<div>
						<div className="flex justify-between bg-eYellow py-4 px-8">
							<p className="font-MontserratSemiBold uppercase">Puertas de seguridad</p>
							<Link to="/productos/seguridad"><img className="w-7" src={GoProductos} alt="Puertas de seguridad" /></Link>
						</div>
						<img src={PuertasSeguridad} className="w-full" alt="Puertas de seguridad" />
					</div>
					<div>
						<div className="flex justify-between bg-eYellow py-4 px-8">
							<p className="font-MontserratSemiBold uppercase">Puertas acorazadas</p>
							<Link to="/productos/acorazadas"><img className="w-7" src={GoProductos} alt="Puertas acorazadas" /></Link>
						</div>
						<img src={PuertasAcorazadas} className="w-full" alt="Puertas acorazadas" />
					</div>
					<div>
						<div className="flex justify-between bg-eYellow py-4 px-8">
							<p className="font-MontserratSemiBold uppercase">Puertas anti-balas</p>
							<Link to="/productos/antibalas"><img className="w-7" src={GoProductos} alt="Puertas anti-balas" /></Link>
						</div>
						<img src={PuertasAntiBalas} className="w-full" alt="Puertas anti-balas" />
					</div>
				</div>
				<div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3 mt-3">
					<div>
						<div className="flex justify-between bg-eYellow py-4 px-8">
							<p className="font-MontserratSemiBold uppercase">Deck</p>
							<Link to="/productos/deck"><img className="w-7" src={GoProductos} alt="Puertas deck" /></Link>
						</div>
						<img src={PuertasDeck} className="w-full" alt="Puertas deck" />
					</div>
					<div>
						<div className="flex justify-between bg-eYellow py-4 px-8">
							<p className="font-MontserratSemiBold uppercase">Alarmas</p>
							<Link to="/productos/otros-productos"><img className="w-7" src={GoProductos} alt="Alarmas" /></Link>
						</div>
						<img src={Alarmas} className="w-full" alt="Alarmas" />
					</div>
					<div>
						<div className="flex justify-between bg-eYellow py-4 px-8">
							<p className="font-MontserratSemiBold uppercase">Cerraduras</p>
							<Link to="/productos/otros-productos"><img className="w-7" src={GoProductos} alt="Cerraduras" /></Link>
						</div>
						<img src={Cerraduras} className="w-full" alt="Cerraduras" />
					</div>
				</div>
			</section>

			<PersonalizaTuPuerta />

			<SatisfaccionGarantizada />

			<section className="containter w-10/12 mx-auto mt-10">
				<div className="lg:flex justify-between items-center mb-10">
					<div>
						<p className="text-2xl text-eBlack font-MontserratRegular">Nuestra puertas más vendidas</p>
					</div>
					<div>
						<Link to="/productos" className="text-xl text-eBlack font-MontserratRegular underline uppercase">ver todos</Link>
					</div>
				</div>

				<div className="h-[450px]">
					<CarouselMasVendidos 
						carousel={carousel}
						baseUrl={baseUrl}
					/>
				</div>
			</section>

			<section className="container w-10/12 mx-auto my-10 lg:my-20">
				<Link to="/productos"><img src={Cintillo1} alt="Ver Productos" /></Link>
			</section>
		
			<section className="containter w-10/12 mx-auto">
				<div className="lg:flex justify-between items-center mb-10">
					<div>
						<p className="text-2xl text-eBlack font-MontserratRegular">Encuentra las mejores promociones</p>
					</div>
					<div>
						<Link to="/productos" className="text-xl text-eBlack font-MontserratRegular underline uppercase">ver todos</Link>
					</div>
				</div>

				<div className="h-[450px]">
					<CarouselPromociones 
						carousel={carousel}
						baseUrl={baseUrl}
					/>
				</div>
			</section>
		
			<section className="container w-10/12 mx-auto my-10 lg:my-20">
				<Link to="/contacto#sucursales">
					<img src={Cintillo2} alt="Ver Sucursales" />
				</Link>
			</section>
		
			<section className="bg-eGray py-14">
				<div className="container w-10/12 mx-auto">
					<p className="font-MontserratRegular text-white text-2xl">Reseñas de nuestros clientes</p>
				</div>
				<div className="container w-10/12 mx-auto h-[344px]">
					<CarouselResenas 
						resenas={resenas}
					/>
				</div>
			</section>

			<Contacto 
				baseUrlApi={baseUrlApi}
			/>
		</>
	)
}

export default Index