import { Link } from "@remix-run/react"
import { useEffect, useState } from "react"
import Slider from 'rc-slider'
import More from "../../public/assets/img/btn-more.webp" 
import Less from "../../public/assets/img/btn-less.webp"

const Filtros = ({puertasApi, productosApi, puertas, setPuertas, setProductos, seguridad, setSeguridad, acorazada, setAcorazada, balistica, setBalistica, granero, setGranero, deck, setDeck, pisoLaminado, setPisoLaminado, otros, setOtros}) => {
    const [ initialPuertas, setInitialPuertas ] = useState({})
    const [ initialProductos, setInitialProductos ] = useState({})

    useEffect( () => {
        const updatePuertas = puertasApi.data.filter( prod => {
            if( seguridad && prod.i_cat === 1 ) {
                return prod
            }
            if ( acorazada && prod.i_cat === 2 ) {
                return prod
            }
            if ( balistica && prod.i_cat === 3 ) {
                return prod
            } 
            if ( granero && prod.i_cat === 4 )  {
                return prod
            }
        })
        setInitialPuertas(updatePuertas)
        
        const updateProductos = productosApi.data.filter( prod => {
            if( deck && prod.i_cat === 4 ) {
                return prod
            }
            if ( pisoLaminado && prod.i_cat === 7 ) {
                return prod
            }
            if ( otros && prod.i_cat !== 7 && prod.i_cat !== 4 ) {
                return prod
            } 
        })
        setInitialProductos(updateProductos)

    },[seguridad, acorazada, balistica, granero, deck, pisoLaminado, otros])

    const [ rangeVal, setRangeVale ] = useState([1000,50000])
    const [ border1, setBorder1 ] = useState("border-eYellow")
    const [ border2, setBorder2 ] = useState("border-eGray")
    const [ border3, setBorder3 ] = useState("border-eGray")

    const [ icon1, setIcon1 ] = useState(Less)
    const [ icon2, setIcon2 ] = useState(More)
    const [ icon3, setIcon3 ] = useState(More)

    const handleExpand = e => {
        setBorder1("border-eGray")
        setBorder2("border-eGray")
        setBorder3("border-eGray")

        switch(e) {
            case "btn1":
                if ( icon1 === More ) {
                    setIcon1(Less)
                } else {
                    setIcon1(More)
                }
                setBorder1("border-eYellow")
                break
            case "btn2":
                if ( icon2 === More ) {
                    setIcon2(Less)
                } else {
                    setIcon2(More)
                }
                setBorder2("border-eYellow")
                break
            case "btn3":
                if ( icon3 === More ) {
                    setIcon3(Less)
                } else {
                    setIcon3(More)
                }
                setBorder3("border-eYellow")
                break
        }
        
    }
    
    const handleTipo = () => {
        let filtros = []
        const filtroTipo = document.querySelectorAll("input[type=checkbox]:checked")
        filtroTipo.forEach( filtro => {
            filtros.push(Number(filtro.value))
        })

        const nuevoArrayPuertas = [...puertasApi.data].filter( puerta => {
            if( filtros.includes(puerta.i_cat) ) {
                return puerta
            }
        })

        const nuevoArrayProductos = [...productosApi.data].filter( producto => {
            if( filtros.includes( +producto.i_cat+100 ) ) {
                return producto
            }
        })

        const nuevoArrayOtrosProductos = [...productosApi.data].filter( producto => {
            if( filtros.includes( 999 ) ) {
                if(producto.i_cat === 1 || producto.i_cat === 2 || producto.i_cat === 3 || producto.i_cat === 5 || producto.i_cat === 6 || producto.i_cat === 8 ){
                    return producto
                }
            }
        })

        const merge = [...nuevoArrayPuertas, ...nuevoArrayProductos, ...nuevoArrayOtrosProductos]

        if ( nuevoArrayPuertas.length === 0 && nuevoArrayProductos.length === 0 && nuevoArrayOtrosProductos.length === 0) {
            setPuertas([...puertasApi.data, ...productosApi.data])
        } else {
            setPuertas(merge)
        }
        
    }

    const handleChange = e => {
        setRangeVale(e)
        const master = [...initialPuertas, ...initialProductos]
        const rango = master.filter( val => val.f_precio.replace(",","") > e[0] && val.f_precio.replace(",","") < e[1] )
        setPuertas(rango)
        setProductos(rango)
    }

    const handleCleanFilters = () => {
        setPuertas([...puertasApi.data, ...productosApi.data])
    }

    return (
        <>
            <div className="w-full lg:w-3/12 pl-10 xl:pl-20 pr-10 py-10 bg-white">
                <p className="text-eGray text-lg font-MontserratRegular pb-10">Filtrar resultados:</p>

                <div id="accordionExample">
                    <div className={`bg-white w-full hover:bg-white focus:ring-0 border-2 ${border1} rounded-lg divide-y-0`}>
                        <h2 className="mb-0" id="headingOne">
                            <button
                                className="group relative flex w-full justify-between items-center border-0 bg-white px-2 py-3 text-left"
                                type="button"
                                onClick={ () => handleExpand("btn1") }
                                data-te-collapse-init
                                data-te-target="#collapseOne"
                                aria-expanded="true"
                                aria-controls="collapseOne">
                                <span className="font-MontserratRegular text-eGray text-sm uppercase">Tipo de producto</span>
                                <img src={icon1} alt="icon" />
                            </button>
                        </h2>
                        <div
                        id="collapseOne"
                        className="!visible"
                        data-te-collapse-item
                        data-te-collapse-show
                        aria-labelledby="headingOne"
                        data-te-parent="#accordionExample">
                            <div className="p-2">
                                <div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="seguridad" 
                                            value="1"
                                            onChange={ e => setSeguridad(e.target.checked) }
                                            checked={seguridad} 
                                        />
                                        <label htmlFor="seguridad" className="text-base font-MontserrantRegular text-eGray ml-3">Seguridad</label>
                                    </div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="acorazada" 
                                            value="2"
                                            onChange={ e => setAcorazada(e.target.checked) }
                                            checked={acorazada} 
                                        />
                                        <label htmlFor="acorazada" className="text-base font-MontserrantRegular text-eGray ml-3">Acorazada</label>
                                    </div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="balistica" 
                                            value="3"
                                            onChange={ e => setBalistica(e.target.checked) }
                                            checked={balistica} 
                                        />
                                        <label htmlFor="balistica" className="text-base font-MontserrantRegular text-eGray ml-3">Balística</label>
                                    </div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="granero" 
                                            value="4"
                                            onChange={ e => setGranero(e.target.checked) }
                                            checked={granero} 
                                        />
                                        <label htmlFor="granero" className="text-base font-MontserrantRegular text-eGray ml-3">Granero</label>
                                    </div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="deck" 
                                            value="104"
                                            onChange={ e => setDeck(e.target.checked) }
                                            checked={deck} 
                                        />
                                        <label htmlFor="deck" className="text-base font-MontserrantRegular text-eGray ml-3">Deck</label>
                                    </div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="laminado" 
                                            value="107"
                                            onChange={ e => setPisoLaminado(e.target.checked) }
                                            checked={pisoLaminado} 
                                        />
                                        <label htmlFor="laminado" className="text-base font-MontserrantRegular text-eGray ml-3">Piso Laminado</label>
                                    </div>
                                    <div onClick={handleTipo}>
                                        <input 
                                            type="checkbox" 
                                            id="otros" 
                                            value="999"
                                            onChange={ e => setOtros(e.target.checked) }
                                            checked={otros} 
                                        />
                                        <label htmlFor="otros" className="text-base font-MontserrantRegular text-eGray ml-3">Otros</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <br />

                    {/*
                    <div className={`bg-white w-full hover:bg-white focus:ring-0 border-2 ${border2} rounded-lg divide-y-0`}>
                        <h2 className="mb-0" id="headingTwo">
                        <button
                            className="group relative flex w-full justify-between items-center border-0 bg-white px-2 py-3 text-left"
                            type="button"
                            data-te-collapse-init
                            data-te-collapse-collapsed
                            onClick={ () => handleExpand("btn2") }
                            data-te-target="#collapseTwo"
                            aria-expanded="false"
                            aria-controls="collapseTwo">
                            <span className="font-MontserratRegular text-eGray text-sm uppercase">subTipo de puerta</span>
                            <img src={icon2} alt="icon" />
                        </button>
                        </h2>
                        <div
                        id="collapseTwo"
                        className="!visible hidden"
                        data-te-collapse-item
                        aria-labelledby="headingTwo"
                        data-te-parent="#accordionExample">
                            <div className="p-2">
                                <div>
                                    <div>
                                        <input type="checkbox" id="op12" />
                                        <label htmlFor="op12" className="text-base font-MontserrantRegular text-eGray ml-3">Seguridad</label>
                                    </div>
                                    <div>
                                        <input type="checkbox" id="op22" />
                                        <label htmlFor="op22" className="text-base font-MontserrantRegular text-eGray ml-3">Acorazada</label>
                                    </div>
                                    <div>
                                        <input type="checkbox" id="op32" />
                                        <label htmlFor="op32" className="text-base font-MontserrantRegular text-eGray ml-3">Balística</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <br />
                    */}
                    
                    <div className={`bg-white w-full hover:bg-white focus:ring-0 border-2 ${border3} rounded-lg divide-y-0`}>
                        <h2 className="accordion-header mb-0" id="headingThree">
                        <button
                            className="group relative flex w-full justify-between items-center border-0 bg-white px-2 py-3 text-left"
                            type="button"
                            data-te-collapse-init
                            data-te-collapse-collapsed
                            onClick={ () => handleExpand("btn3") }
                            data-te-target="#collapseThree"
                            aria-expanded="false"
                            aria-controls="collapseThree">
                            <span className="font-MontserratRegular text-eGray text-sm uppercase">rango de precio</span>
                            <img src={icon3} alt="icon" />
                        </button>
                        </h2>
                        <div
                        id="collapseThree"
                        className="!visible hidden"
                        data-te-collapse-item
                        aria-labelledby="headingThree"
                        data-te-parent="#accordionExample">
                            <div className="p-2">
                                <div className="flex">
                                    
                                    <p className="font-MontserratRegular text-eGray text-xs mr-2">{rangeVal[0]}</p>
                                    <Slider 
                                        range
                                        min={1000}
                                        max={50000}
                                        value={rangeVal}
                                        step={1000}
                                        onChange={ e => handleChange(e) } 
                                        className="sliderange"
                                        tipFormatter={rangeVal => console.log()}
                                        tipProps={
                                            {
                                                placement: 'top',
                                                prefixCls: 'rc-slider-tooltip',
                                                overlay: rangeVal
                                            }
                                        }
                                    />
                                    <p className="font-MontserratRegular text-eGray text-xs ml-2">{rangeVal[1]}</p>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div className="flex justify-center items-center mt-5">
                    <button onClick={handleCleanFilters} className="bg-transparent hover:bg-transparent text-eBlue font-MontserratRegular underline">Limpiar filtros</button>
                </div>
            </div> 
        </>
    )
}

export default Filtros
    