import { useEffect, useState } from "react"

const ListaOpcionesFijo = ({
    fijoOptionsShow, 
    Empty,
    dataOpcionesFijo, 
    configuracion, 
    configuracionFijo, 
    setFijoBatiente, 
    setFijoPivote, 
    setFijoAbatible, 
    setFijoDoble, baseUrl, puertaMedidaCarrito, setPuertaMedidaCarrito, design
}) => {
    const [ seleccion, setSeleccion ] = useState("")

    useEffect(() => {
        if (typeof dataOpcionesFijo.length === 'undefined') {
            setSeleccion("")
        }
    }, [dataOpcionesFijo])
    
    const loadOpcion = (ox_batiente, xo_batiente, osx_batiente, oxo_batiente, osox_batiente, osxo_batiente, osoxo_batiente, ox_pivote, xo_pivote, osx_pivote, oxo_pivote, osox_pivote, osxo_pivote, osoxo_pivote, ox_doble, xo_doble, osx_doble, oxo_doble, osox_doble, osxo_doble, osoxo_doble, id, precio) => {
        if( configuracionFijo === "ox" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+ox_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: ox_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+ox_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: ox_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+ox_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: ox_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+ox_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: ox_doble })
                    break
            }
            setSeleccion(id)
        } else if( configuracionFijo === "xo" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+xo_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: xo_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+xo_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: xo_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+xo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: xo_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+xo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: xo_doble })
                    break
            }
            setSeleccion(id)
        } else if( configuracionFijo === "osx" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+osx_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osx_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+osx_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osx_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+osx_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osx_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+osx_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osx_doble })
                    break
            }
            setSeleccion(id)
        } else if( configuracionFijo === "oxo" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+oxo_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: oxo_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+oxo_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: oxo_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+oxo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: oxo_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+oxo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: oxo_doble })
                    break
            }
            setSeleccion(id)
        } else if( configuracionFijo === "osox" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+osox_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osox_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+osox_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osox_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+osox_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osox_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+osox_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osox_doble })
                    break
            }
            setSeleccion(id)
        } else if( configuracionFijo === "osxo" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+osxo_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osxo_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+osxo_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osxo_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+osxo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osxo_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+osxo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osxo_doble })
                    break
            }
            setSeleccion(id)
        } else if( configuracionFijo === "osoxo" ) {
            switch(configuracion) {
                case "batiente":
                    setFijoBatiente(baseUrl+osoxo_batiente)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osoxo_batiente })
                    break
                case "pivote":
                    setFijoPivote(baseUrl+osoxo_pivote)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osoxo_pivote })
                    break
                case "fijoabatible":
                    setFijoAbatible(baseUrl+osoxo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osoxo_doble })
                    break
                case "doble":
                    setFijoDoble(baseUrl+osoxo_doble)
                    setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: configuracionFijo, configuracionFijoPrecio: precio, configuracionFijoImagen: osoxo_doble })
                    break
            }
            setSeleccion(id)
        }
    }

    const remove = () => {
        setPuertaMedidaCarrito({ ...puertaMedidaCarrito, configuracionFijo: "x", configuracionFijoPrecio: "", configuracionFijoImagen: "" })
        
        setSeleccion("")
        setFijoBatiente(Empty)
        setFijoPivote(Empty)
        setFijoAbatible(Empty)
        setFijoDoble(Empty)
    }

    return (
        <div className={`mt-5 flex ${design} gap-5 ${fijoOptionsShow}`}>
            {
                dataOpcionesFijo?.length ? (
                    dataOpcionesFijo.map( opts => (
                        <div key={opts.id} className={`bg-white w-32 flex flex-col justify-center items-center px-2 py-5 ${opts.id === seleccion ? 'border-2 border-solid border-eYellow' : ''}`}>
                            <img src={baseUrl+opts.vc_img_preview} alt="Fijo" className="w-full mb-3" />
                            <p className="w-full text-center text-eGray font-MontserratRegular text-sm">{opts.vc_nombre}</p>
                            {
                                ( configuracion === "batiente") ? 
                                    <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio}</p> 
                                : 
                                    ( configuracion === "pivote") ? 
                                        <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio}</p> 
                                    : 
                                        ( configuracion === "fijoabatible") ? 
                                            <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio}</p> 
                                                : 
                                                    ( configuracion === "doble") ? 
                                                        <p className="w-full text-center text-eGray font-MontserratSemiBold text-sm">+${opts.f_precio}</p> 
                                                            : 
                                                                "No hay opciones"
                            }
                            {
                                opts.id === seleccion ? <button onClick={() => remove()} className="mt-5 bg-eLightGray text-eGray text-sm px-4 py-1 rounded-full">Remover</button>
                                : <button onClick={() => loadOpcion(opts.vc_img_ox_batiente, opts.vc_img_xo_batiente, opts.vc_img_osx_batiente, opts.vc_img_oxo_batiente, opts.vc_img_osox_batiente, opts.vc_img_osxo_batiente, opts.vc_img_osoxo_batiente, opts.vc_img_ox_pivote, opts.vc_img_xo_pivote, opts.vc_img_osx_pivote, opts.vc_img_oxo_pivote, opts.vc_img_osox_pivote, opts.vc_img_osxo_pivote, opts.vc_img_osoxo_pivote, opts.vc_img_ox_doble, opts.vc_img_xo_doble, opts.vc_img_osx_doble, opts.vc_img_oxo_doble, opts.vc_img_osox_doble, opts.vc_img_osxo_doble, opts.vc_img_osoxo_doble, opts.id, opts.f_precio)} className="mt-5 bg-eYellow text-eGray text-sm px-4 py-1 rounded-full">Agregar</button>
                            }
                        </div>
                    ))
                ) : "No hay opciones de diseño"
            }
        </div>
    )
}

export default ListaOpcionesFijo