import { Form, Link } from "@remix-run/react"
import { Rating } from "flowbite-react"
import { useState } from "react"

import CarouselMasVendidos from "~/components/carouselmasvendidos"
import PersonalizaTuPuerta from "~/components/personalizatupuerta"

import Next from "../../public/assets/img/next-btn.webp"
import Prev from "../../public/assets/img/back-btn.webp"
import Galeria1 from "../../public/assets/img/puerta-galeria-01.webp"
import Galeria2 from "../../public/assets/img/puerta-galeria-02.webp"
import Galeria3 from "../../public/assets/img/puerta-galeria-03.webp"
import Galeria4 from "../../public/assets/img/puerta-galeria-04.webp"
import Search from "../../public/assets/img/btn-buscar.webp"
import Cerradura1 from "../../public/assets/img/img-cerradura1.webp"
import Cerradura2 from "../../public/assets/img/img-cerradura2.webp"
import Less from "../../public/assets/img/btn-less.webp"
import More from "../../public/assets/img/btn-more.webp"
import CartDark from "../../public/assets/img/cart-icon-dark.webp"
import CheckGreen from "../../public/assets/img/check-icon-green.webp"

const ProductosDetalle = () => {
    const [ cantidad, setCantidad ] = useState(0)
    const [ galeria, setGaleria ] = useState(Galeria1)
    
    return (
        <div className="bg-eLightGray">

            <section className="container w-10/12 mx-auto">
                <div className="lg:flex py-10">
                    <div className="w-full lg:w-5/12 lg:m-5">
                        <div className="bg-white rounded-md p-2 sm:p-20">
                            <img src={galeria} alt="Galería" />
                        </div>
                        <div className="flex mt-5">
                            <div className="w-1/12 flex justify-center items-center">
                                <img src={Prev} alt="Previo" />
                            </div>
                            <div className="w-10/12">
                                <div className="flex">
                                    <div className="m-3 rounded-md">
                                        <button className="focus:border-4 focus:border-eBlue rounded-md"><img src={Galeria1} onClick={() => setGaleria(Galeria1)} alt="Galeria 1" /></button>
                                    </div>
                                    <div className="m-3 rounded-md">
                                        <button className="focus:border-4 focus:border-eBlue rounded-md"><img src={Galeria2} onClick={() => setGaleria(Galeria2)} alt="Galeria 2" /></button>
                                    </div>
                                    <div className="m-3 rounded-md">
                                        <button className="focus:border-4 focus:border-eBlue rounded-md"><img src={Galeria3} onClick={() => setGaleria(Galeria3)} alt="Galeria 3" /></button>
                                    </div>
                                    <div className="m-3 rounded-md">
                                        <button className="focus:border-4 focus:border-eBlue rounded-md"><img src={Galeria4} onClick={() => setGaleria(Galeria4)} alt="Galeria 4" /></button>
                                    </div>
                                </div>
                            </div>
                            <div className="w-1/12 flex justify-center items-center">
                                <img src={Next} alt="Siguiente" />
                            </div>
                        </div>
                    </div>
                    <div className="w-full lg:w-7/12 lg:m-5">
                        <div className="grid grid-cols-1 lg:flex justify-between">
                            <div className="lg:w-6/12">
                                <p className="font-MontserratSemiBold text-eGray text-2xl">
                                    Puerta de seguridad cartagena
                                </p>
                            </div>
                            <div className="lg:w-6/12 flex flex-col justify-start items-end">
                                <p className="font-MontserratSemiBold text-eGray text-2xl">$12,871.00</p>
                                <Rating>
                                    <Rating.Star />
                                    <Rating.Star />
                                    <Rating.Star />
                                    <Rating.Star />
                                    <Rating.Star filled={false} />
                                </Rating>
                            </div>
                        </div>

                        {/** */}
                        <ul className="mb-0 flex list-none flex-col flex-wrap border-b-0 pl-0 md:flex-row" role="tablist" data-te-nav-ref>
                            <li role="presentation" className="flex-auto text-center">
                                <a href="#tabs-home01" className="mt-2 block border-x-0 border-b-2 border-t-0 border-transparent px-7 pb-3.5 pt-4 text-xs font-MontserratRegular uppercase leading-tight text-eGray hover:isolate hover:border-transparent hover:bg-white focus:isolate focus:border-transparent data-[te-nav-active]:bg-white data-[te-nav-active]:text-eGray dark:text-neutral-400 dark:hover:bg-transparent dark:data-[te-nav-active]:border-primary-400 dark:data-[te-nav-active]:text-primary-400" data-te-toggle="pill" data-te-target="#tabs-home01" data-te-nav-active role="tab" aria-controls="tabs-home01" aria-selected="true">descripción</a>
                            </li>
                            <li role="presentation" className="flex-auto text-center">
                                <a href="#tabs-profile01" className="focus:border-transparen mt-2 block border-x-0 border-b-2 border-t-0 border-transparent px-7 pb-3.5 pt-4 text-xs font-MontserratRegular uppercase leading-tight text-eGray hover:isolate hover:border-transparent hover:bg-white focus:isolate data-[te-nav-active]:bg-white data-[te-nav-active]:border-white data-[te-nav-active]:text-eGray dark:text-neutral-400 dark:hover:bg-transparent dark:data-[te-nav-active]:border-primary-400 dark:data-[te-nav-active]:text-primary-400" data-te-toggle="pill" data-te-target="#tabs-profile01" role="tab" aria-controls="tabs-profile01" aria-selected="false">características</a>
                            </li>
                            <li role="presentation" className="flex-auto text-center">
                                <a href="#tabs-messages01" className="mt-2 block border-x-0 border-b-2 border-t-0 border-transparent px-7 pb-3.5 pt-4 text-xs font-MontserratRegular uppercase leading-tight text-eGray hover:isolate hover:border-transparent hover:bg-white focus:isolate focus:border-transparent data-[te-nav-active]:bg-white data-[te-nav-active]:border-white data-[te-nav-active]:text-primary dark:text-neutral-400 dark:hover:bg-transparent dark:data-[te-nav-active]:border-primary-400 dark:data-[te-nav-active]:text-eGray-400" data-te-toggle="pill" data-te-target="#tabs-messages01" role="tab" aria-controls="tabs-messages01" aria-selected="false">ficha técnica</a>
                            </li>
                        </ul>

                        <div className="mb-6">
                            <div
                                className="hidden  transition-opacity duration-150 ease-linear data-[te-tab-active]:block data-[te-tab-active]:bg-white px-10 py-5"
                                id="tabs-home01"
                                role="tabpanel"
                                aria-labelledby="tabs-home-tab01"
                                data-te-tab-active>
                                <ul>
                                    <li className="font-MontserratRegular"> - Medida de producto: 120cm x 213cm</li>
                                    <li className="font-MontserratRegular"> - Ancho de pureta: 5cm</li>
                                    <li className="font-MontserratRegular"> - Puntos de seguridad: 16 pernos</li>
                                    <li className="font-MontserratRegular"> - Manija de acero</li>
                                    <li className="font-MontserratRegular"> - Bisagras de acero reforzadas ocultas</li>
                                    <li className="font-MontserratRegular"> - Acabado Chocolate</li>
                                    <li className="font-MontserratRegular"> - Kit de instalación básica incluido</li>
                                    <li className="font-MontserratRegular"> - Manual de instalación</li>
                                </ul>
                            </div>
                            <div
                                className="hidden opacity-0 transition-opacity duration-150 ease-linear data-[te-tab-active]:block data-[te-tab-active]:bg-white px-10 py-5"
                                id="tabs-profile01"
                                role="tabpanel"
                                aria-labelledby="tabs-profile-tab01">
                                <ul>
                                    <li className="font-MontserratRegular"> - Medida de producto: 120cm x 213cm</li>
                                    <li className="font-MontserratRegular"> - Ancho de pureta: 5cm</li>
                                    <li className="font-MontserratRegular"> - Puntos de seguridad: 16 pernos</li>
                                    <li className="font-MontserratRegular"> - Manija de acero</li>
                                    <li className="font-MontserratRegular"> - Bisagras de acero reforzadas ocultas</li>
                                    <li className="font-MontserratRegular"> - Acabado Chocolate</li>
                                    <li className="font-MontserratRegular"> - Kit de instalación básica incluido</li>
                                    <li className="font-MontserratRegular"> - Manual de instalación</li>
                                </ul>
                            </div>
                            <div
                                className="hidden opacity-0 transition-opacity duration-150 ease-linear data-[te-tab-active]:block data-[te-tab-active]:bg-white px-10 py-5"
                                id="tabs-messages01"
                                role="tabpanel"
                                aria-labelledby="tabs-profile-tab01">
                                <ul>
                                    <li className="font-MontserratRegular"> - Medida de producto: 120cm x 213cm</li>
                                    <li className="font-MontserratRegular"> - Ancho de pureta: 5cm</li>
                                    <li className="font-MontserratRegular"> - Puntos de seguridad: 16 pernos</li>
                                    <li className="font-MontserratRegular"> - Manija de acero</li>
                                    <li className="font-MontserratRegular"> - Bisagras de acero reforzadas ocultas</li>
                                    <li className="font-MontserratRegular"> - Acabado Chocolate</li>
                                    <li className="font-MontserratRegular"> - Kit de instalación básica incluido</li>
                                    <li className="font-MontserratRegular"> - Manual de instalación</li>
                                </ul>
                            </div>
                        </div>
                        {/** */}

                        <div className="lg:flex gap-4 mt-10">
                            <div className="lg:w-6/12">
                                <label htmlFor="apertura" className="font-MontserratRegular">Dirección de apertura:</label>
                                <select id="apertura" className="mt-5 w-full bg-dropPattern rounded-md border-2 focus:border-eYellow focus:ring-0 border-eGray uppercase content-none select:appearance-none" >
                                    <option value="">Selecciona</option>
                                    <option value="izq">Izquierda</option>
                                    <option value="der">Derecha</option>
                                </select>
                            </div>
                            <div className="lg:w-6/12 mt-5 lg:mt-0">
                                <label htmlFor="cobertura" className="font-MontserratRegular">Cobertura de envío:</label>
                                <Form className="mt-5">
                                    <div className="flex "> 
                                        <input id="cobertura" type="text" placeholder="CÓDIGO POSTAL" className="focus:border-eYellow focus:ring-0 border-2 border-r-0 border-eGray rounded-l-md w-full" />
                                        <button className="bg-white border-2 border-l-0 border-eGray focus:ring-0 rounded-r-md" type="submit">
                                            <img src={Search} alt="Buscar" className="p-1" />
                                        </button>
                                    </div>
                                </Form>
                            </div>
                        </div>

                        <hr className="my-10" />

                        <p className="uppercase font-MontserratSemiBold text-eBlack ml-5">Agrega una cerradura digital a tu puerta:</p>

                        <div className="lg:flex gap-2 border-eYellow border-2 bg-white py-5 px-3 mt-5">
                            <div className="lg:w-2/12 flex justify-center">
                                <img src={Cerradura1} alt="Cerradura 1" />
                            </div>
                            <div className="lg:w-7/12 flex flex-col justify-center items-center">
                                <p className="text-eGray text-2xl w-full">Cerradura smart home</p>
                                <div className="w-full flex justify-between items-center py-5 lg:py-0">
                                    <p className="font-MontserratSemiBold text-eGray">+ $12,700.00</p>
                                    <p><Link to="/" className="text-eBlue underline">Ver detalles</Link></p>
                                </div>
                            </div>
                            <div className="lg:w-3/12 flex justify-center items-center">
                                <p className="font-MontserratSemiBold text-eYellow pr-2">Agregado</p>
                                <div><img src={Less} alt="Agregado" /></div>
                            </div>

                        </div>

                        <div className="lg:flex gap-2 bg-white py-5 px-3 mt-5">
                            <div className="lg:w-2/12 flex justify-center">
                                <img src={Cerradura2} alt="Cerradura 2" />
                            </div>
                            <div className="lg:w-7/12 flex flex-col justify-center items-center">
                                <p className="text-eGray text-2xl w-full">Cerradura smart home II</p>
                                <div className="w-full flex justify-between items-center py-5 lg:py-0">
                                    <p className="font-MontserratSemiBold text-eGray">+ $12,700.00</p>
                                    <p><Link to="/" className="text-eBlue underline">Ver detalles</Link></p>
                                </div>
                            </div>
                            <div className="lg:w-3/12 flex justify-center items-center">
                                <p className="font-MontserratSemiBold text-eGray pr-2">Agregar</p>
                                <div><img src={More} alt="Agregado" /></div>
                            </div>

                        </div>

                        <hr className="my-10" />

                        <div className="lg:flex gap-2 py-5 lg:px-0">
                            <div className="lg:w-4/12 flex justify-center items-center gap-2">
                                <img src={CheckGreen} alt="Disponible" />
                                <p className="font-MontserratRegular text-eGreen">Disponible</p>
                            </div>
                            <div className="lg:w-4/12 flex py-5 lg:px-0">
                                <button onClick={() => setCantidad(cantidad-1)} className="w-full bg-black rounded-l-md">
                                    <p className="font-MontserratBold text-white">-</p>
                                </button>
                                <input className="w-full text-center font-MontserratBold" type="text" value={cantidad} />
                                <button onClick={() => setCantidad(cantidad+1)} className="w-full bg-black rounded-r-md">
                                    <p className="font-MontserratBold text-white">+</p>
                                </button>
                            </div>
                            <div className="lg:w-4/12 py-5 lg:px-0 flex justify-center">
                                <button className="flex gap-1 justify-center items-center bg-eYellow rounded-md py-2 px-4">
                                    <img src={CartDark} alt="Agregar al carrito" />
                                    <p className="font-MontserratRegular text-xs">Agregar al carrito</p>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>
            </section>

            <hr className="mb-10" />

            <section className="containter w-10/12 mx-auto mb-20">
                <div className="lg:flex justify-between items-center mb-10">
                    <div className="py-2 sm:py-0">
                        <p className="text-2xl text-eBlack font-MontserratRegular">Nuestra puertas más vendidas</p>
                    </div>
                    <div className="py-2 sm:py-0">
                        <Link to="#" className="text-xl text-eBlack font-MontserratRegular underline uppercase">ver todos</Link>
                    </div>
                </div>

                <div className="h-96">
                    <CarouselMasVendidos />
                </div>
            </section>

            <PersonalizaTuPuerta />
        </div>
    )
}

export default ProductosDetalle
