import { Link, useLoaderData, useOutletContext } from "@remix-run/react"
import { useEffect, useState, useRef } from "react"
import Swal from "sweetalert2"
import { getPuertaBase, getElementos, getFijos, getPesos } from "~/models/puertasMedida.server"
import ListaOpcionesTexturaExterior from "~/components/puertasamedida/listaopcionestexturaexterior"
import ListaOpcionesTexturaInterior from "~/components/puertasamedida/listaopcionestexturainterior"
import ListaOpcionesArmazon from "~/components/puertasamedida/listaopcionesarmazon"
import ListaOpcionesDiseno from "~/components/puertasamedida/listaopcionesdiseno"
import ListaOpcionesCristal from "~/components/puertasamedida/listaopcionescristal"
import ListaOpcionesCelosia from "~/components/puertasamedida/listaopcionescelosia"
import ListaOpcionesManeral from "~/components/puertasamedida/listaopcionesmaneral"
import ListaOpcionesManija from "~/components/puertasamedida/listaopcionesmanija"
import ListaOpcionesFijo from "~/components/puertasamedida/listaopcionesfijo"
import IconBatiente from "../../public/assets/img/batiente-icon.webp"
import IconPivote from "../../public/assets/img/pivote-icon.webp"
import IconAbatible from "../../public/assets/img/fabatible-icon.webp"
import IconDoble from "../../public/assets/img/doble-icon.webp"
import FlechaInterior from "../../public/assets/img/interior-flecha.webp"
import IconoSuperior from "../../public/assets/img/modular-superior.webp"
import IconoLateralIzquierdo from "../../public/assets/img/modular-izq.webp"
import IconoLateralDerecho from "../../public/assets/img/modular-der.webp"
import Empty from "../../public/assets/img/empty.webp"
import Presentacion from "../../public/assets/img/presentacion.webp"
import Go from "../../public/assets/img/go-icon.webp"
import styles from "../styles/main.css"
import { Tooltip } from 'react-tooltip'
import 'react-tooltip/dist/react-tooltip.css'
import { generarId } from "~/helpers/functions"

export async function loader() {
    const [base, elementos, fijos, pesos] = await Promise.all( [ getPuertaBase(), getElementos(), getFijos(), getPesos() ] )
    const exteriorDeck = elementos.data.filter(value => value.id_textura_tipo === 1 && value.id_elemento_tipo === 1 && value.id > 0 )
    const exteriorMdf = elementos.data.filter(value => value.id_textura_tipo === 2 && value.id_elemento_tipo === 1 && value.id > 0 )
    const exteriorAlocubon = elementos.data.filter(value => value.id_textura_tipo === 3 && value.id_elemento_tipo === 1 && value.id > 0 )
    const exteriorAcero = elementos.data.filter(value => value.id_textura_tipo === 4 && value.id_elemento_tipo === 1 && value.id > 0 )
    const exteriorLumbrin = elementos.data.filter(value => value.id_textura_tipo === 5 && value.id_elemento_tipo === 1 && value.id > 0 )
    const exteriorPremium = elementos.data.filter(value => value.id_textura_tipo === 6 && value.id_elemento_tipo === 1 && value.id > 0 )
    const exteriorDeckPremium = elementos.data.filter(value => value.id_textura_tipo === 7 && value.id_elemento_tipo === 1 && value.id > 0 )

    
    const interiorDeck = elementos.data.filter(value => value.id_textura_tipo === 1 && value.id_elemento_tipo === 2 && value.id > 0 )
    const interiorMdf = elementos.data.filter(value => value.id_textura_tipo === 2 && value.id_elemento_tipo === 2 && value.id > 0 )
    const interiorAlocubon = elementos.data.filter(value => value.id_textura_tipo === 3 && value.id_elemento_tipo === 2 && value.id > 0 )
    const interiorAcero = elementos.data.filter(value => value.id_textura_tipo === 4 && value.id_elemento_tipo === 2 && value.id > 0 )
    const interiorLumbrin = elementos.data.filter(value => value.id_textura_tipo === 5 && value.id_elemento_tipo === 2 && value.id > 0 )
    const interiorPremium = elementos.data.filter(value => value.id_textura_tipo === 6 && value.id_elemento_tipo === 2 && value.id > 0 )
    const interiorDeckPremium = elementos.data.filter(value => value.id_textura_tipo === 7 && value.id_elemento_tipo === 2 && value.id > 0 )
    
    const armazones = elementos.data.filter(value => value.id_elemento_tipo === 3 )
    const disenos = elementos.data.filter(value => value.id_elemento_tipo === 4 )
    const cristal = elementos.data.filter(value => value.id_elemento_tipo === 5 )
    const celosia = elementos.data.filter(value => value.id_elemento_tipo === 6 ) 
    const maneral = elementos.data.filter(value => value.id_elemento_tipo === 7 )
    const manija = elementos.data.filter(value => value.id_elemento_tipo === 8 )

    loadedData = {
        base: base.data[0], 
        exteriorDeck: exteriorDeck,
        exteriorMdf: exteriorMdf,
        exteriorAlocubon: exteriorAlocubon,
        exteriorAcero: exteriorAcero, 
        exteriorLumbrin: exteriorLumbrin, 
        exteriorPremium: exteriorPremium, 
        exteriorDeckPremium: exteriorDeckPremium, 
        interiorDeck: interiorDeck,
        interiorMdf: interiorMdf,
        interiorAlocubon: interiorAlocubon,
        interiorAcero: interiorAcero,
        interiorLumbrin: interiorLumbrin, 
        interiorPremium: interiorPremium, 
        interiorDeckPremium: interiorDeckPremium,
        armazones: armazones,
        disenos: disenos, 
        cristal: cristal, 
        celosia: celosia, 
        maneral: maneral, 
        manija: manija, 
        fijos: fijos.data, 
        pesos: pesos.data, 
        baseUrl: process.env.WEB_URL
    }
    return loadedData
}

export function links() {
    return [
        {
            rel: 'stylesheet',
            href: styles
        }
    ]
}

const PuertasMedidaWeb = () => {
    const ref = useRef(null)
    const finalDoor = ref.current

    const { setCarritoMedida } = useOutletContext()
    const loadedData = useLoaderData()
    const { base, exteriorDeck, exteriorMdf, exteriorAlocubon, exteriorAcero, exteriorLumbrin, exteriorPremium, exteriorDeckPremium, interiorDeck, interiorMdf, interiorAlocubon, interiorAcero, interiorLumbrin, interiorPremium, interiorDeckPremium, armazones, disenos, cristal, celosia, maneral, manija, fijos, pesos, baseUrl } = loadedData
    
    const [ displayPresentacion, setDisplayPresentacion ] = useState("")
    const [ displayConstruccion, setDisplayConstruccion ] = useState("hidden")
    const [ vanoAlto, setVanoAlto ] = useState(0)
    const [ vanoAncho, setVanoAncho ] = useState(0)
    const [ puertaAlto, setPuertaAlto ] = useState("")
    const [ puertaAncho, setPuertaAncho ] = useState("")
    const [ seleccionaPuerta, setSeleccionaPuerta ] = useState("hidden")
    const [ anchoFijoAbatible, setAnchoFijoAbatible ] = useState("30")
    const [ displayAnchoFijoAbatible, setDisplayAnchoFijoAbatible ] = useState("hidden")
    const [ puertaMedidaCarrito, setPuertaMedidaCarrito ] = useState({})

    const [ listaOpciones, setListaOpciones ] = useState("hidden")
    
    const [showCalcular, setShowCalcular] = useState("")

    const [ opcionBatiente, setOpcionBatiente ] = useState("hidden")
    const [ opcionPivote, setOpcionPivote ] = useState("hidden")
    const [ opcionFijoAbatible, setOpcionFijoAbatible ] = useState("hidden")
    const [ opcionDoble, setOpcionDoble ] = useState("hidden")
    const [ opcionFijoIzquierdo, setOpcionFijoIzquierdo ] = useState("hidden")
    const [ opcionFijoSuperior, setOpcionFijoSuperior ] = useState("hidden")
    const [ opcionFijoDerecho, setOpcionFijoDerecho ] = useState("hidden")
    
    const [ seleccionaTexturaExterior, setSeleccionaTexturaExterior ] = useState("hidden")
    const [ seleccionaTexturaInterior, setSeleccionaTexturaInterior ] = useState("hidden")

    const [ optExterior, setOptExterior ] = useState("")
    const [ optInterior, setOptInterior ] = useState("")

    const [ seleccionaArmazon, setSeleccionaArmazon ] = useState("hidden")
    const [ seleccionaDiseno, setSeleccionaDiseno ] = useState("hidden")
    const [ seleccionaCristal, setSeleccionaCristal] = useState("hidden")
    const [ seleccionaCelosia, setSeleccionaCelosia] = useState("hidden")
    const [ seleccionaManeral, setSeleccionaManeral] = useState("hidden")
    const [ seleccionaManija, setSeleccionaManija] = useState("hidden")
    const [ seleccionaApertura, setSeleccionaApertura] = useState("hidden")
    const [ seleccionaFijos, setSeleccionaFijos ] = useState("hidden")

    const [ configuracion, setConfiguracion ] = useState("")
    const [ configuracionFijo, setConfiguracionFijo ] = useState("")
    const [ dataOpcionesExterior, setDataOpcionesExterior ] = useState({})
    const [ dataOpcionesInterior, setDataOpcionesInterior ] = useState({})
    const [ dataOpcionesArmazon, setDataOpcionesArmazon ] = useState({})
    const [ dataOpcionesDiseno, setDataOpcionesDiseno ] = useState({})
    const [ dataOpcionesCristal, setDataOpcionesCristal ] = useState({})
    const [ dataOpcionesCelosia, setDataOpcionesCelosia ] = useState({})
    const [ dataOpcionesManeral, setDataOpcionesManeral ] = useState({})
    const [ dataOpcionesManija, setDataOpcionesManija ] = useState({})
    const [ dataOpcionesFijo, setDataOpcionesFijo ] = useState({})

    const [ showAcabados, setShowAcabados ] = useState("hidden")

    const [ chambrana, setChambrana ] = useState("no")
    const [ mirilla, setMirilla ] = useState("no")
    const [ cubrepolvo, setCubrepolvo ] = useState("no")
    const [ mecanismo, setMecanismo ] = useState("5")

    /** Preview */
        /**Batiente */
        const [ puertaBatientePreview, setPuertaBatientePreview ] = useState("hidden")
        const [ texturaBatiente, setTexturaBatiente ] = useState(Empty)
        const [ texturaIntBatiente, setTexturaIntBatiente ] = useState(Empty)
        const [ armazonBatiente, setArmazonBatiente ] = useState(Empty)
        const [ disenoBatiente, setDisenoBatiente ] = useState(Empty)
        const [ cristalBatiente, setCristalBatiente ] = useState(Empty)
        const [ celosiaBatiente, setCelosiaBatiente ] = useState(Empty)
        const [ maneralBatiente, setManeralBatiente ] = useState(Empty)
        const [ manijaBatiente, setManijaBatiente ] = useState(Empty)
        const [ fijoBatiente, setFijoBatiente ] = useState(Empty)

        /**Pivote */
        const [ puertaPivotePreview, setPuertaPivotePreview ] = useState("hidden")
        const [ texturaPivote, setTexturaPivote ] = useState(Empty)
        const [ texturaIntPivote, setTexturaIntPivote ] = useState(Empty)
        const [ armazonPivote, setArmazonPivote ] = useState(Empty)
        const [ disenoPivote, setDisenoPivote ] = useState(Empty)
        const [ cristalPivote, setCristalPivote ] = useState(Empty)
        const [ celosiaPivote, setCelosiaPivote ] = useState(Empty)
        const [ maneralPivote, setManeralPivote ] = useState(Empty)
        const [ manijaPivote, setManijaPivote ] = useState(Empty)
        const [ fijoPivote, setFijoPivote ] = useState(Empty)

        /**Fijo Abatible */
        const [ puertaFijoAbatiblePreview, setPuertaFijoAbatiblePreview ] = useState("hidden")
        const [ texturaFijoAbatible, setTexturaFijoAbatible ] = useState(Empty)
        const [ texturaIntFijoAbatible, setTexturaIntFijoAbatible ] = useState(Empty)
        const [ armazonFijoAbatible, setArmazonFijoAbatible ] = useState(Empty)
        const [ disenoFijoAbatible, setDisenoFijoAbatible ] = useState(Empty)
        const [ cristalFijoAbatible, setCristalFijoAbatible ] = useState(Empty)
        const [ celosiaFijoAbatible, setCelosiaFijoAbatible ] = useState(Empty)
        const [ maneralFijoAbatible, setManeralFijoAbatible ] = useState(Empty)
        const [ manijaFijoAbatible, setManijaFijoAbatible ] = useState(Empty)
        const [ fijoFijoAbatible, setFijoAbatible ] = useState(Empty)
        
        /**Doble */
        const [ puertaDoblePreview, setPuertaDoblePreview ] = useState("hidden")
        const [ texturaDoble, setTexturaDoble ] = useState(Empty)
        const [ texturaIntDoble, setTexturaIntDoble ] = useState(Empty)
        const [ armazonDoble, setArmazonDoble ] = useState(Empty)
        const [ disenoDoble, setDisenoDoble ] = useState(Empty)
        const [ cristalDoble, setCristalDoble ] = useState(Empty)
        const [ celosiaDoble, setCelosiaDoble ] = useState(Empty)
        const [ maneralDoble, setManeralDoble ] = useState(Empty)
        const [ manijaDoble, setManijaDoble ] = useState(Empty)
        const [ fijoDoble, setFijoDoble ] = useState(Empty)
    /** Preview */

    const [ cubiertaExteriorOptionsShow, setCubiertaExteriorOptionsShow ] = useState("hidden")
    const [ cubiertaInteriorOptionsShow, setCubiertaInteriorOptionsShow ] = useState("hidden")
    const [ armazonOptionsShow, setArmazonOptionsShow ] = useState("hidden")
    const [ disenoOptionsShow, setDisenoOptionsShow ] = useState("hidden")
    const [ cristalOptionsShow, setCristalOptionsShow ] = useState("hidden")
    const [ celosiaOptionsShow, setCelosiaOptionsShow ] = useState("hidden")
    const [ maneralOptionsShow, setManeralOptionsShow ] = useState("hidden")
    const [ manijaOptionsShow, setManijaOptionsShow ] = useState("hidden")
    const [ fijoOptionsShow, setFijoOptionsShow ] = useState("hidden")

    const [ apertura, setApertura ] = useState("scale-x-100")
    const [ aperturaInvertida, setAperturaInvertida ] = useState("-scale-x-100")

    useEffect( () => {
        setPuertaMedidaCarrito( { puertaMedida: { id: generarId() } } )
    }, [])

    const handleCalcular = () => {
        setShowCalcular("") //hidden

        setSeleccionaPuerta("hidden")
        setSeleccionaTexturaExterior("hidden")
        setSeleccionaTexturaInterior("hidden")
        setSeleccionaArmazon("hidden")
        setSeleccionaDiseno("hidden")
        setSeleccionaCristal("hidden")
        setSeleccionaCelosia("hidden")
        setSeleccionaManeral("hidden")
        setSeleccionaManija("hidden")
        setSeleccionaApertura("hidden")
        setSeleccionaFijos("hidden")

        const inputs = document.querySelectorAll("input")
        inputs.forEach( val => {
            val.checked=false
        })

        setTexturaBatiente(Empty)
        setArmazonBatiente(Empty)
        setDisenoBatiente(Empty)
        setCristalBatiente(Empty)
        setCelosiaBatiente(Empty)
        setManeralBatiente(Empty)
        setManijaBatiente(Empty)
        setFijoBatiente(Empty)
        setTexturaPivote(Empty)
        setArmazonPivote(Empty)
        setDisenoPivote(Empty)
        setCristalPivote(Empty)
        setCelosiaPivote(Empty)
        setManeralPivote(Empty)
        setManijaPivote(Empty)
        setFijoPivote(Empty)
        setTexturaFijoAbatible(Empty)
        setArmazonFijoAbatible(Empty)
        setDisenoFijoAbatible(Empty)
        setCristalFijoAbatible(Empty)
        setCelosiaFijoAbatible(Empty)
        setManeralFijoAbatible(Empty)
        setManijaFijoAbatible(Empty)
        setFijoAbatible(Empty)
        setTexturaDoble(Empty)
        setArmazonDoble(Empty)
        setDisenoDoble(Empty)
        setCristalDoble(Empty)
        setCelosiaDoble(Empty)
        setManeralDoble(Empty)
        setManijaDoble(Empty)
        setFijoDoble(Empty)

        setDataOpcionesExterior({})
        setDataOpcionesInterior({})
        setDataOpcionesArmazon({})
        setDataOpcionesDiseno({})
        setDataOpcionesCristal({})
        setDataOpcionesCelosia({})
        setDataOpcionesManeral({})
        setDataOpcionesManija({})
        setDataOpcionesFijo({})

        if( +puertaAlto < 210 ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El alto de la puerta debe ser de al menos 210 cms",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
            setShowCalcular("")
        } else if( +puertaAncho < 70 ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El ancho de la puerta debe ser de al menos 70 cms",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
            setShowCalcular("")
        } else if( +puertaAlto > 300 ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El alto de la puerta debe ser menor a 300 cms",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
            setShowCalcular("")
        } else if( +puertaAncho > 300 ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El ancho de la puerta debe ser menor a 300 cms",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
            setShowCalcular("")
        } else {
            setSeleccionaPuerta("")
            setOpcionBatiente("hidden")
            setOpcionPivote("hidden")
            setOpcionFijoAbatible("hidden")
            setOpcionDoble("hidden")

            if ( +puertaAncho > 69 && +puertaAncho < 115 ) {
                setOpcionBatiente("")
            }

            if ( +puertaAncho > 113 && +puertaAncho < 301 ) {
                setOpcionPivote("")
            }

            if ( +puertaAncho > 99 && +puertaAncho < 185 ) {
                setOpcionFijoAbatible("")
            }

            if ( +puertaAncho > 139 && +puertaAncho < 229 ) {
                setOpcionDoble("")
            }

            setPuertaMedidaCarrito({ ...puertaMedidaCarrito.puertaMedida, vanoAlto: vanoAlto, vanoAncho: vanoAncho, puertaAlto: puertaAlto, puertaAncho: puertaAncho })
        }
    }
    
    const handleOptions = opt => {
        setDisplayPresentacion("hidden")
        setDisplayConstruccion("") 
        setPuertaMedidaCarrito({ ...puertaMedidaCarrito, opcionPuerta: opt })

        const inputs = document.querySelectorAll("input")
        inputs.forEach( val => {
            if( val.name !== "puertaTipo" ) {
                val.checked=false
            }
        })

        setTexturaBatiente(Empty)
        setArmazonBatiente(Empty)
        setDisenoBatiente(Empty)
        setCristalBatiente(Empty)
        setCelosiaBatiente(Empty)
        setManeralBatiente(Empty)
        setManijaBatiente(Empty)
        setFijoBatiente(Empty)
        setTexturaPivote(Empty)
        setArmazonPivote(Empty)
        setDisenoPivote(Empty)
        setCristalPivote(Empty)
        setCelosiaPivote(Empty)
        setManeralPivote(Empty)
        setManijaPivote(Empty)
        setFijoPivote(Empty)
        setTexturaFijoAbatible(Empty)
        setArmazonFijoAbatible(Empty)
        setDisenoFijoAbatible(Empty)
        setCristalFijoAbatible(Empty)
        setCelosiaFijoAbatible(Empty)
        setManeralFijoAbatible(Empty)
        setManijaFijoAbatible(Empty)
        setFijoAbatible(Empty)
        setTexturaDoble(Empty)
        setArmazonDoble(Empty)
        setDisenoDoble(Empty)
        setCristalDoble(Empty)
        setCelosiaDoble(Empty)
        setManeralDoble(Empty)
        setManijaDoble(Empty)
        setFijoDoble(Empty)

        setDataOpcionesExterior({})
        setDataOpcionesInterior({})
        setDataOpcionesArmazon({})
        setDataOpcionesDiseno({})
        setDataOpcionesCristal({})
        setDataOpcionesCelosia({})
        setDataOpcionesManeral({})
        setDataOpcionesManija({})
        setDataOpcionesFijo({})

        setPuertaBatientePreview("hidden")
        setTexturaBatiente("")
        setPuertaPivotePreview("hidden")
        setTexturaPivote("")
        setPuertaFijoAbatiblePreview("hidden")
        setTexturaFijoAbatible("")
        setPuertaDoblePreview("hidden")
        setTexturaDoble("")

        switch(opt){
            case "batiente":
                setDisplayAnchoFijoAbatible("hidden")
                setConfiguracion("batiente")
                setPuertaBatientePreview("")
                setTexturaBatiente("https://testing1.eversafe.com.mx"+base.vc_img_batiente)
                break
            case "pivote":
                setDisplayAnchoFijoAbatible("hidden")
                setConfiguracion("pivote")
                setPuertaPivotePreview("")
                setTexturaPivote("https://testing1.eversafe.com.mx"+base.vc_img_pivote)
                break
            case "fijoabatible":
                setDisplayAnchoFijoAbatible("")
                setConfiguracion("fijoabatible")
                setPuertaFijoAbatiblePreview("")
                setTexturaFijoAbatible("https://testing1.eversafe.com.mx"+base.vc_img_batiente_fijo)
                break
            case "doble":
                setDisplayAnchoFijoAbatible("hidden")
                setConfiguracion("doble")
                setPuertaDoblePreview("")
                setTexturaDoble("https://testing1.eversafe.com.mx"+base.vc_img_doble)
                break
        }

        // 30 hasta 150
        /*if ( (vanoAlto-puertaAlto) > 29 && (vanoAlto-puertaAlto) < 151 ) {
            setSeleccionaFijos("")
            setOpcionFijoSuperior("")
        }

        if ( (vanoAncho-puertaAncho) > 29 && (vanoAncho-puertaAncho) < 151 ) {
            setSeleccionaFijos("")
            setOpcionFijoIzquierdo("")
            setOpcionFijoDerecho("")
        }

        if( (vanoAncho-puertaAncho) < 30 && (vanoAlto-puertaAlto) < 30 ) {
            setSeleccionaTexturaExterior("")
        }*/

        if ( (puertaAlto-30) > 209 ) {
            setSeleccionaFijos("")
            setOpcionFijoSuperior("")
        }

        if ( (puertaAncho-30) > 69 ) {
            setSeleccionaFijos("")
            setOpcionFijoIzquierdo("")
            setOpcionFijoDerecho("")
        }

        setSeleccionaTexturaExterior("")
    }

    const handleFijos = () => {
        setListaOpciones("")

        /*if ( puertaMedidaCarrito.opcionPuerta === "fijoabatible" && anchoFijoAbatible === "" ) {
            const anchoFA = document.querySelector("#valorAnchoFijoAbatible")
            anchoFA.focus()
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe ingresar el ancho del fijo abatible",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( +puertaAncho + +anchoFijoAbatible > +vanoAncho ) {
            const fIzq = document.querySelector("#fijoizq") 
            const fSup = document.querySelector("#fijosup")
            const fDer = document.querySelector("#fijoder")
            fIzq.checked = false
            fSup.checked = false
            fDer.checked = false

            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El ancho de la puerta más el ancho del fijo no pueden superar el ancho del vano",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( puertaMedidaCarrito.opcionPuerta === "fijoabatible" && anchoFijoAbatible < 30 ) {
            const fIzq = document.querySelector("#fijoizq") 
            const fSup = document.querySelector("#fijosup")
            const fDer = document.querySelector("#fijoder")
            fIzq.checked = false
            fSup.checked = false
            fDer.checked = false
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El ancho del fijo abatible debe ser mayor a 30 cms",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            }) 
        } else {*/
            setPuertaMedidaCarrito({ ...puertaMedidaCarrito, anchoFijoAbatible: anchoFijoAbatible })

            const izq = document.querySelector("#fijoizq")
            const sup = document.querySelector("#fijosup")
            const der = document.querySelector("#fijoder")

            if ( izq.checked && !der.checked && !sup.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAncho - 30 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("ox")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAncho - 90 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("ox")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAncho - 60 < 140 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("ox")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAncho - 60 < 115 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("ox")
                            loadOptionsFijo()
                        }
                        break;
                }
            } else if ( der.checked && !izq.checked && !sup.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAncho - 30 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("xo")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAncho - 90 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("xo")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAncho - 60 < 140 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("xo")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAncho - 60 < 115 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("xo")
                            loadOptionsFijo()
                        }
                        break;
                }
            } else if ( sup.checked && !izq.checked && !der.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAlto - 30 < 210 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osx")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAlto - 30 < 210 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osx")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAlto - 30 < 210 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osx")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAlto - 30 < 210 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osx")
                            loadOptionsFijo()
                        }
                        break;
                }
            } else if ( der.checked && izq.checked && !sup.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAncho - 30 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("oxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAncho - 90 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("oxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAncho - 60 < 140 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("oxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAncho - 60 < 115 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("oxo")
                            loadOptionsFijo()
                        }
                        break;
                }
            } else if ( izq.checked && sup.checked && !der.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 30 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osox")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 60 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osox")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 30 < 140 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osox")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 30 < 115 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osox")
                            loadOptionsFijo()
                        }
                        break;
                }
            } else if ( der.checked && sup.checked && !izq.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 30 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 60 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 30 < 140 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAlto - 30 < 210 || puertaAncho - 30 < 115 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar el fijo",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osxo")
                            loadOptionsFijo()
                        }
                        break;
                }
            } else if ( der.checked && izq.checked && sup.checked ) {
                switch ( puertaMedidaCarrito.opcionPuerta ) {
                    case "batiente":
                        if ( puertaAncho - 30 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osoxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "fijoabatible":
                        if ( puertaAncho - 90 < 70 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osoxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "doble":
                        if ( puertaAncho - 60 < 140 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osoxo")
                            loadOptionsFijo()
                        }
                        break;
                    case "pivote":
                        if ( puertaAncho - 60 < 115 ) {
                            Swal.fire({
                                title: "<h2>¡Atención!</h2>",
                                html: "No hay suficiente espacio para agregar ambos fijos",
                                icon: 'warning',
                                confirmButtonText: ' Cerrar ',
                                confirmButtonColor: '#eabb2e',
                            })
                        } else {
                            setConfiguracionFijo("osoxo")
                            loadOptionsFijo()
                        }
                        break;
                }
            }
        /*}*/
    }

    const loadOptionsExterior = opt => {
        setOptExterior(opt)
        setListaOpciones("")

        setCubiertaExteriorOptionsShow("")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")

        switch(opt) {
            case "Deck": 
                setDataOpcionesExterior(exteriorDeck)
                setSeleccionaTexturaInterior("")
                break
            case "MDF": 
                setDataOpcionesExterior(exteriorMdf)
                setSeleccionaTexturaInterior("")
                break
            case "Alocubon": 
                setDataOpcionesExterior(exteriorAlocubon)
                setSeleccionaTexturaInterior("")
                break
            case "Acero": 
                setDataOpcionesExterior(exteriorAcero)
                setSeleccionaTexturaInterior("")
                break
            case "Lumbrin": 
                setDataOpcionesExterior(exteriorLumbrin)
                setSeleccionaTexturaInterior("")
                break
            case "Premium": 
                setDataOpcionesExterior(exteriorPremium)
                setSeleccionaTexturaInterior("")
                break
            case "DeckPremium": 
                setDataOpcionesExterior(exteriorDeckPremium)
                setSeleccionaTexturaInterior("")
                break

        }
    }

    const loadOptionsInterior = opt => {
        setOptInterior(opt)
        setListaOpciones("")
        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")
        
        setSeleccionaArmazon("")

        switch(opt) {
            case "Deck": 
                setDataOpcionesInterior(interiorDeck)
                //setSeleccionaTexturaInterior("")
                break
            case "MDF": 
                setDataOpcionesInterior(interiorMdf)
                //setSeleccionaTexturaInterior("")
                break
            case "Alocubon": 
                setDataOpcionesInterior(interiorAlocubon)
                //setSeleccionaTexturaInterior("")
                break
            case "Acero": 
                setDataOpcionesInterior(interiorAcero)
                //setSeleccionaTexturaInterior("")
                break
            case "Lumbrin": 
                setDataOpcionesInterior(interiorLumbrin)
                //setSeleccionaTexturaInterior("")
                break
            case "Premium": 
                setDataOpcionesInterior(interiorPremium)
                //setSeleccionaTexturaInterior("")
                break
            case "DeckPremium": 
                setDataOpcionesInterior(interiorDeckPremium)
                //setSeleccionaTexturaInterior("")
                break
        }
    }

    const loadOptionsArmazon = () => {
        setListaOpciones("")
        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")        

        setDataOpcionesArmazon(armazones)
        setSeleccionaManija("")
        setSeleccionaManeral("")
        setSeleccionaDiseno("")
        setSeleccionaCristal("")
        setSeleccionaCelosia("")
    }

    const loadOptionsDiseno = e => {
        setListaOpciones("")
        setSeleccionaCristal("")

        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")

        setDataOpcionesDiseno(disenos)
    }

    const loadOptionsCristal = e => {
        setListaOpciones("")
        setSeleccionaCelosia("")

        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")

        setDataOpcionesCristal(cristal)
    }

    const loadOptionsCelosia = e => {
        setListaOpciones("")
        setSeleccionaManeral("")

        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")

        setDataOpcionesCelosia(celosia)
    }

    const loadOptionsManeral = e => {
        setListaOpciones("")
        setSeleccionaManija("")

        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")

        setDataOpcionesManeral(maneral)
    }

    const loadOptionsManija = e => {
        setListaOpciones("")
        setSeleccionaApertura("")

        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("")
        setFijoOptionsShow("hidden")

        setDataOpcionesManija(manija)
    }

    const loadOptionsFijo = e => {
        setListaOpciones("")
        setSeleccionaTexturaExterior("")
        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("")
        setDataOpcionesFijo(fijos)
    }

    const handleApertura = e => {
        setListaOpciones("hidden")
        setCubiertaExteriorOptionsShow("hidden")
        setCubiertaInteriorOptionsShow("hidden")
        setArmazonOptionsShow("hidden")
        setDisenoOptionsShow("hidden")
        setCristalOptionsShow("hidden")
        setCelosiaOptionsShow("hidden")
        setManeralOptionsShow("hidden")
        setManijaOptionsShow("hidden")
        setFijoOptionsShow("hidden")

        switch(e) {
            case "intIzq":
                setApertura("-scale-x-100")
                setAperturaInvertida("scale-x-100")
                setPuertaMedidaCarrito({ ...puertaMedidaCarrito, apertura: "intIzq" })
                break
            case "intDer":
                setApertura("scale-x-100")
                setAperturaInvertida("-scale-x-100")
                setPuertaMedidaCarrito({ ...puertaMedidaCarrito, apertura: "intDer" })
                break
            case "extIzq":
                setApertura("-scale-x-100")
                setAperturaInvertida("scale-x-100")
                setPuertaMedidaCarrito({ ...puertaMedidaCarrito, apertura: "extIzq" })
                break
            case "extDer":
                setApertura("scale-x-100")
                setAperturaInvertida("-scale-x-100")
                setPuertaMedidaCarrito({ ...puertaMedidaCarrito, apertura: "extDer" })
                break
        }
    }

    const handleCheckout = () => {
        let sorting = [], tot = 0

        if ( typeof puertaMedidaCarrito.id === 'undefined' || puertaMedidaCarrito.id === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "No se ha construido ninguna puerta",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.puertaAlto === 'undefined' || puertaMedidaCarrito.puertaAlto === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe ingresar las medidas del la puerta",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.opcionPuerta === 'undefined' || puertaMedidaCarrito.opcionPuerta === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe elegir una opción de puerta",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } /*else if ( +puertaMedidaCarrito.puertaAncho + +puertaMedidaCarrito.anchoFijoAbatible > +puertaMedidaCarrito.vanoAncho ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El ancho de la puerta más el ancho del fijo no pueden superar el ancho del vano",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } */else if ( puertaMedidaCarrito.opcionPuerta === "fijoabatible" && puertaMedidaCarrito.anchoFijoAbatible < 30 ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "El ancho del fijo abatible debe ser mayor a 30 cms",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.texturaExterior === 'undefined' || puertaMedidaCarrito.texturaExterior === "") {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe elegir una cubierta exterior",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.textInterior === 'undefined' || puertaMedidaCarrito.textInterior === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe elegir una cubierta interior",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.textArmazon === 'undefined' || puertaMedidaCarrito.textArmazon === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe elegir un armazon",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.textManija === 'undefined' || puertaMedidaCarrito.textManija === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe elegir una manija",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( typeof puertaMedidaCarrito.apertura === 'undefined' || puertaMedidaCarrito.apertura === "" ) {
            Swal.fire({
                title: "<h2>¡Atención!</h2>",
                html: "Debe elegir una dirección de apertura",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else {

            let areaPuerta, fijoSuperior, fijoLateral, areaFijos, costoFijos, costoTexturaExterior, costoTexturaInterior, costoArmazon, costoDiseno, costoCristal, costoCelosia, costoManeral, costoManija
            
            /*
            areaPuerta = (puertaMedidaCarrito.puertaAlto * puertaMedidaCarrito.puertaAncho) / 10000
            fijoSuperior = ((puertaMedidaCarrito.vanoAlto-puertaMedidaCarrito.puertaAlto) * puertaMedidaCarrito.vanoAncho) / 10000
            fijoLateral = ((puertaMedidaCarrito.vanoAncho-puertaMedidaCarrito.puertaAncho) * puertaMedidaCarrito.puertaAlto) / 10000
            areaFijos = +fijoSuperior + +fijoLateral
            */

            areaPuerta = (puertaMedidaCarrito.puertaAlto * puertaMedidaCarrito.puertaAncho) / 10000
            fijoSuperior = ((puertaMedidaCarrito.puertaAlto-30) * puertaMedidaCarrito.puertaAncho) / 10000
            fijoLateral = ((puertaMedidaCarrito.puertaAncho-30) * puertaMedidaCarrito.puertaAlto) / 10000
            areaFijos = +fijoSuperior + +fijoLateral
            
            if ( typeof puertaMedidaCarrito.configuracionFijoPrecio !== 'undefined' ) {
                costoFijos = +puertaMedidaCarrito.configuracionFijoPrecio * +areaFijos
                tot = ( +tot + +costoFijos )
            }
            if ( typeof puertaMedidaCarrito.texturaExteriorPrecio !== 'undefined' ) {
                costoTexturaExterior = (+puertaMedidaCarrito.texturaExteriorPrecio * areaPuerta)
                tot = ( +tot + +costoTexturaExterior)
            }
            if ( typeof puertaMedidaCarrito.textInteriorPrecio !== 'undefined' ) {
                costoTexturaInterior = (+puertaMedidaCarrito.textInteriorPrecio * areaPuerta)
                tot = ( +tot + +costoTexturaInterior)
            }
            if ( typeof puertaMedidaCarrito.textArmazonPrecio !== 'undefined' ) {
                costoArmazon = (+puertaMedidaCarrito.textArmazonPrecio)
                tot = ( +tot + +costoArmazon)
            }
            if ( typeof puertaMedidaCarrito.textDisenoPrecio !== 'undefined' ) {
                costoDiseno = (+puertaMedidaCarrito.textDisenoPrecio)
                tot = ( +tot + +costoDiseno)
            }
            if ( typeof puertaMedidaCarrito.textCristalPrecio !== 'undefined' ) {
                costoCristal = (+puertaMedidaCarrito.textCristalPrecio)
                tot = ( +tot + +costoCristal)
            }
            if ( typeof puertaMedidaCarrito.textCelosiaPrecio !== 'undefined' ) {
                costoCelosia = (+puertaMedidaCarrito.textCelosiaPrecio)
                tot = ( +tot + +costoCelosia)
            }
            if ( typeof puertaMedidaCarrito.textManeralPrecio !== 'undefined' ) {
                costoManeral = (+puertaMedidaCarrito.textManeralPrecio)
                tot = ( +tot + +costoManeral)
            }
            if ( typeof puertaMedidaCarrito.textManijaPrecio !== 'undefined' ) {
                costoManija = (+puertaMedidaCarrito.textManijaPrecio)
                tot = ( +tot + +costoManija)
            }

            if ( puertaMedidaCarrito.textCelosia !== "" && puertaMedidaCarrito.textCristal === "" ) {
                Swal.fire({
                    title: "<h2>¡Atención!</h2>",
                    html: "Para elegir una celosia también debes incluir un cristal",
                    icon: 'warning',
                    confirmButtonText: ' Cerrar ',
                    confirmButtonColor: '#eabb2e',
                })
            } else {
                setPuertaMedidaCarrito({ ...puertaMedidaCarrito, totalPuertaMedida: tot.toFixed(2) })
                sorting.push({id: puertaMedidaCarrito.id})
                sorting.push({vanoAlto: puertaMedidaCarrito.vanoAlto, vanoAncho: puertaMedidaCarrito.vanoAncho, puertaAlto: puertaMedidaCarrito.puertaAlto, puertaAncho: puertaMedidaCarrito.puertaAncho})
                sorting.push({opcionPuerta: puertaMedidaCarrito.opcionPuerta, anchofijoabatible: typeof puertaMedidaCarrito.anchoFijoAbatible !== "undefined" ? puertaMedidaCarrito.anchoFijoAbatible : "" })
                //sorting.push({configuracionFijo: puertaMedidaCarrito.configuracionFijo, configuracionFijoImagen: puertaMedidaCarrito.configuracionFijoImagen, configuracionFijoPrecio: puertaMedidaCarrito.configuracionFijoPrecio})
                if ( typeof puertaMedidaCarrito.configuracionFijo === 'undefined' ) {
                    sorting.push({configuracionFijo: "x", configuracionFijoImagen: "", configuracionFijoPrecio: 0})
                } else {
                    sorting.push({configuracionFijo: puertaMedidaCarrito.configuracionFijo, configuracionFijoImagen: puertaMedidaCarrito.configuracionFijoImagen, configuracionFijoPrecio: puertaMedidaCarrito.configuracionFijoPrecio})
                }
                sorting.push({texturaExterior: puertaMedidaCarrito.texturaExterior, texturaExteriorImagen: puertaMedidaCarrito.texturaExteriorImagen, texturaExteriorPrecio: puertaMedidaCarrito.texturaExteriorPrecio, nombreTexturaExterior: puertaMedidaCarrito.nombreTexturaExterior})
                sorting.push({textInterior: puertaMedidaCarrito.textInterior, textInteriorImagen: puertaMedidaCarrito.textInteriorImagen, textInteriorPrecio: puertaMedidaCarrito.textInteriorPrecio, nombreTexturaInterior: puertaMedidaCarrito.nombreTexturaInterior})
                sorting.push({textArmazon: puertaMedidaCarrito.textArmazon, textArmazonImagen: puertaMedidaCarrito.textArmazonImagen, textArmazonPrecio: puertaMedidaCarrito.textArmazonPrecio, nombreArmazon: puertaMedidaCarrito.nombreArmazon})

                if ( typeof puertaMedidaCarrito.textDiseno === 'undefined' ) {
                    sorting.push({textDiseno: "", textDisenoImagen: "", textDisenoPrecio: "", nombreDiseno: ""})
                } else {
                    sorting.push({textDiseno: puertaMedidaCarrito.textDiseno, textDisenoImagen: puertaMedidaCarrito.textDisenoImagen, textDisenoPrecio: puertaMedidaCarrito.textDisenoPrecio, nombreDiseno: puertaMedidaCarrito.nombreDiseno})
                }

                if ( typeof puertaMedidaCarrito.textCristal === 'undefined' ) {
                    sorting.push({textCristal: "", textCristalImagen: "", textCristalPrecio: "", nombreCristal: ""})
                } else {
                    sorting.push({textCristal: puertaMedidaCarrito.textCristal, textCristalImagen: puertaMedidaCarrito.textCristalImagen, textCristalPrecio: puertaMedidaCarrito.textCristalPrecio, nombreCristal: puertaMedidaCarrito.nombreCristal})
                }

                if ( typeof puertaMedidaCarrito.textCelosia === 'undefined' ) {
                    sorting.push({textCelosia: "", textCelosiaImagen: "", textCelosiaPrecio: "", nombreCelosia: ""})
                } else {
                    sorting.push({textCelosia: puertaMedidaCarrito.textCelosia, textCelosiaImagen: puertaMedidaCarrito.textCelosiaImagen, textCelosiaPrecio: puertaMedidaCarrito.textCelosiaPrecio, nombreCelosia: puertaMedidaCarrito.nombreCelosia})
                }
                
                if ( typeof puertaMedidaCarrito.textManeral === 'undefined' ) {
                    sorting.push({textManeral: "", textManeralImagen: "", textManeralPrecio: "", nombreManeral: ""})
                } else {
                    sorting.push({textManeral: puertaMedidaCarrito.textManeral, textManeralImagen: puertaMedidaCarrito.textManeralImagen, textManeralPrecio: puertaMedidaCarrito.textManeralPrecio, nombreManeral: puertaMedidaCarrito.nombreManeral})
                }
                
                sorting.push({textManija: puertaMedidaCarrito.textManija, textManijaImagen: puertaMedidaCarrito.textManijaImagen, textManijaPrecio: puertaMedidaCarrito.textManijaPrecio, nombreManija: puertaMedidaCarrito.nombreManija})
                sorting.push({apertura: puertaMedidaCarrito.apertura})
                sorting.push({totalPuertaMedida: tot.toFixed(2)})


                
                
                const fijosPeso = (areaFijos * pesos[0].i_peso) + (areaFijos * pesos[10].i_peso)
                let exteriorPeso = 0, interiorPeso = 0, disenoPeso = 0, cristalPeso = 0, celosiaPeso = 0
                
                const armazonPeso = areaPuerta * pesos[1].i_peso

                switch ( optExterior ) {
                    case "Deck":
                        exteriorPeso = areaPuerta * pesos[2].i_peso
                        break
                    case "MDF":
                        exteriorPeso = areaPuerta * pesos[3].i_peso
                        break
                    case "Alocubon":
                        exteriorPeso = areaPuerta * pesos[4].i_peso
                        break
                    case "Acero":
                        exteriorPeso = areaPuerta * pesos[5].i_peso
                        break
                    case "Lumbrin":
                        exteriorPeso = areaPuerta * pesos[5].i_peso
                        break
                    case "Premium":
                        exteriorPeso = areaPuerta * pesos[5].i_peso
                        break
                    case "DeckPremium":
                        exteriorPeso = areaPuerta * pesos[5].i_peso
                        break
                }
                
                switch ( optInterior ) {
                    case "Deck":
                        interiorPeso = areaPuerta * pesos[2].i_peso
                        break
                    case "MDF":
                        interiorPeso = areaPuerta * pesos[3].i_peso
                        break
                    case "Alocubon":
                        interiorPeso = areaPuerta * pesos[4].i_peso
                        break
                    case "Acero":
                        interiorPeso = areaPuerta * pesos[5].i_peso
                        break
                    case "Lumbrin":
                        interiorPeso = areaPuerta * pesos[5].i_peso
                        break
                    case "Premium":
                        interiorPeso = areaPuerta * pesos[5].i_peso
                        break
                    case "DeckPremium":
                        interiorPeso = areaPuerta * pesos[5].i_peso
                        break
                }

                if ( typeof puertaMedidaCarrito.textDiseno !== "undefined" ) {
                    disenoPeso = areaPuerta * pesos[6].i_peso
                }

                if ( typeof puertaMedidaCarrito.textCristal !== "undefined" ) {
                    cristalPeso = areaPuerta * pesos[7].i_peso
                }

                if ( typeof puertaMedidaCarrito.textCelosia !== "undefined" ) {
                    celosiaPeso = areaPuerta * pesos[8].i_peso
                }

                const componentesPeso = areaPuerta * pesos[9].i_peso
                const empaquePuertaPeso = areaPuerta * pesos[10].i_peso

                let puertaArmada = []
                finalDoor.childNodes.forEach(element => {
                    if( !element.classList.contains('hidden') ) {
                        element.childNodes.forEach(element2 => {
                            if ( typeof element2.childNodes[0] != 'undefined' ) {
                                if ( element2.childNodes[0].alt === 'Textura' ) {
                                    puertaArmada.push({textura: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Armazon' ) {
                                    puertaArmada.push({armazon: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Diseño' ) {
                                    puertaArmada.push({diseno: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Cristal' ) {
                                    puertaArmada.push({cristal: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Celosia' ) {
                                    puertaArmada.push({celosia: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Maneral' ) {
                                    puertaArmada.push({maneral: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Manija' ) {
                                    puertaArmada.push({manija: element2.childNodes[0].src})
                                } else if ( element2.childNodes[0].alt === 'Fijos' ) {
                                    puertaArmada.push({fijos: element2.childNodes[0].src})
                                }
                            }
                        })
                    }
                })

                sorting.push({medidaAncho: puertaMedidaCarrito.puertaAncho, medidaAlto: puertaMedidaCarrito.puertaAlto, fijosPeso: fijosPeso, puertaPeso: armazonPeso + exteriorPeso + interiorPeso + disenoPeso + cristalPeso + celosiaPeso + componentesPeso + empaquePuertaPeso, imageFinal: puertaArmada}) 

                sorting.push( {chambrana: chambrana, mirilla: mirilla, cubrepolvo: cubrepolvo, mecanismo: mecanismo} )

                setCarritoMedida(sorting)

                window.location.href = "/carrito"
            }
        }

    }

    return (
        <main className="w-full mx-auto">
            <div className="lg:flex">
                <div className="lg:w-4/12 p-5 bg-eLightGray h-[500px] overflow-hidden overflow-y-scroll">
                    <h1 className="font-MontserratSemiBold uppercase text-center text-lg text-eBlue mb-5">Crea tu puerta a la medida:</h1>

                    {/*<div className="my-5">
                        <div className="flex items-center">
                            <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Medidas de vano</p>
                            <Link to="/como-medir.pdf" target="_blank">
                                <span className="ml-3 bg-eYellow rounded-full px-2">
                                    <span className="text-white text-xs font-MontserratBold">?</span>
                                </span>
                            </Link>
                        </div>
                        <div className="flex items-center gap-2 mt-2">
                            <p className="text-MontserratRegular text-eGray">Ancho: </p>
                            <input 
                                type="text" 
                                id="anchoVano" 
                                name="anchoVano" 
                                placeholder="Ancho cm" 
                                value={vanoAncho}
                                onChange={ e => setVanoAncho(e.target.value) }
                                className="font-MontserratRegular border-solid rounded-md text-sm w-28 focus:ring-eYellow focus:border-eYellow" />
                            <p className="text-MontserratRegular text-eGray">Alto: </p>
                            <input 
                                type="text" 
                                id="altoVano" 
                                name="altoVano" 
                                placeholder="Alto cm" 
                                value={vanoAlto}
                                onChange={ e => setVanoAlto(e.target.value) }
                                className="font-MontserratRegular border-solid rounded-md text-sm w-28 focus:ring-eYellow focus:border-eYellow" />
                        </div>
                    </div>*/}

                    <div className="my-5">
                        <div className="flex items-center">
                            <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Medidas de puerta</p>
                            <Link to="/como-medir.pdf" target="_blank">
                                <span className="ml-3 bg-eYellow rounded-full px-2">
                                    <span className="text-white text-xs font-MontserratBold">?</span>
                                </span>
                            </Link>
                        </div>
                        <div className="flex items-center gap-2 mt-2">
                            <p className="text-MontserratRegular text-eGray">Ancho: </p>
                            <input 
                                type="text" 
                                id="anchoPuerta" 
                                name="anchoPuerta" 
                                placeholder="Ancho cm" 
                                value={puertaAncho}
                                onChange={ e => setPuertaAncho(e.target.value) }
                                className="font-MontserratRegular border-solid rounded-md text-sm w-28 focus:ring-eYellow focus:border-eYellow" />
                            <p className="text-MontserratRegular text-eGray">Alto: </p>
                            <input 
                                type="text" 
                                id="altoPuerta" 
                                name="altoPuerta" 
                                placeholder="Alto cm" 
                                value={puertaAlto}
                                onChange={ e => setPuertaAlto(e.target.value) }
                                className="font-MontserratRegular border-solid rounded-md text-sm w-28 focus:ring-eYellow focus:border-eYellow" />
                        </div>
                    </div>

                    <div className={`flex justify-center items-center ${showCalcular}`}>
                        <a href="/puertas-a-medida" className=" mx-2 bg-eYellow text-eGray font-MontserratSemiBold py-2 px-8 rounded-full">Limpiar</a>
                        <button type="button" onClick={handleCalcular} className=" mx-2 bg-eYellow text-eGray font-MontserratSemiBold py-2 px-8 rounded-full">Calcular</button>
                    </div>
                    
                    <div className={`my-5 ${seleccionaPuerta}`}>
                        <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Selecciona una opción</p>
                        <div className="flex gap-2 justify-center items-start mt-2">
                            <div className={`checkbox-wrapper-16 ${opcionBatiente}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onChange={ () => handleOptions("batiente") } 
                                        type="radio" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        name="puertaTipo" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconBatiente} alt="Puerta Batiente" className="m-2 h-28" />
                                    </span>
                                    <span className="checkbox-label">Batiente</span>
                                    </span>
                                </label>
                            </div>
                            <div className={`checkbox-wrapper-16 ${opcionPivote}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onChange={ () => handleOptions("pivote") } 
                                        type="radio" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        name="puertaTipo" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconPivote} alt="Puerta Pivote" className="m-2 h-28" />
                                    </span>
                                    <span className="checkbox-label">Pivote</span>
                                    </span>
                                </label>
                            </div>
                            <div className={`checkbox-wrapper-16 ${opcionFijoAbatible}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onChange={ () => handleOptions("fijoabatible") } 
                                        type="radio" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        name="puertaTipo" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconAbatible} alt="Puerta con Fijo Abatible" className="m-2 h-28" />
                                    </span>
                                    <span className="checkbox-label">Fijo Abatible</span>
                                    </span>
                                </label>
                            </div>
                            <div className={`checkbox-wrapper-16 ${opcionDoble}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onChange={ () => handleOptions("doble") } 
                                        type="radio" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        name="puertaTipo" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconDoble} alt="Puerta Doble" className="m-2 h-28" />
                                    </span>
                                    <span className="checkbox-label">Doble</span>
                                    </span>
                                </label>
                            </div>
                        </div>
                        <div className="flex justify-center items-center mt-2">
                            <input 
                                type="hidden" 
                                id="valorAnchoFijoAbatible"
                                value={anchoFijoAbatible}
                                onChange={e => setAnchoFijoAbatible(e.target.value)}
                                placeholder="Ancho del fijo en cms" 
                                className={`${displayAnchoFijoAbatible} w-6/12 font-MontserratRegular border-solid rounded-md text-sm focus:ring-eYellow focus:border-eYellow`} 
                                name="anchofijo"/>
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaFijos}`}>
                        <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Selecciona una opción</p>
                        <div className="flex gap-2 justify-center items-start mt-2">
                            <div className={`checkbox-wrapper-16 ${opcionFijoIzquierdo}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onClick={ () => handleFijos() } 
                                        type="checkbox" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        id="fijoizq"
                                        name="fijoizq" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconoLateralIzquierdo} alt="Fijo lateral izquierdo" className="m-2 w-16" />
                                    </span>
                                    <span className="checkbox-label">Lateral izq.</span>
                                    </span>
                                </label>
                            </div>
                            <div className={`checkbox-wrapper-16 ${opcionFijoSuperior}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onClick={ () => handleFijos() } 
                                        type="checkbox" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        id="fijosup"
                                        name="fijosup" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconoSuperior} alt="Fijo Superior" className="m-2 w-16" />
                                    </span>
                                    <span className="checkbox-label">Superior</span>
                                    </span>
                                </label>
                            </div>
                            <div className={`checkbox-wrapper-16 ${opcionFijoDerecho}`}>
                                <label className="checkbox-wrapper">
                                    <input 
                                        onClick={ () => handleFijos() } 
                                        type="checkbox" 
                                        className="checkbox-input focus:ring-eYellow" 
                                        id="fijoder"
                                        name="fijoder" />
                                    <span className="checkbox-tile">
                                    <span className="checkbox-icon">
                                        <img src={IconoLateralDerecho} alt="Fijo lateral derecho" className="m-2 w-16" />
                                    </span>
                                    <span className="checkbox-label">Lateral Der.</span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaTexturaExterior}`}>
                        <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Cubierta exterior</p>
                        <div className="grid grid-cols-3 gap-2 mt-2">
                            {
                                exteriorDeck.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="deckExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("Deck") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="deckExterior" className="ml-2">Deck</label>
                                </div> : ""
                            }

                            {
                                exteriorMdf.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="mdfExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("MDF") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="mdfExterior" className="ml-2">MDF</label>
                                </div> : ""
                            }

                            {
                                exteriorAlocubon.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="alocubonExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("Alocubon") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="alocubonExterior" className="ml-2">Alucubond</label>
                                </div> : ""
                            }

                            {
                                exteriorAcero.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="aceroExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("Acero") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="aceroExterior" className="ml-2">Acero</label>
                                </div> : ""
                            }

                            {
                                exteriorLumbrin.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="lumbrinExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("Lumbrin") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="lumbrinExterior" className="ml-2">Lumbrin</label>
                                </div> : ""
                            }

                            {
                                exteriorPremium.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="premiumExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("Premium") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="premiumExterior" className="ml-2">Premium</label>
                                </div> : ""
                            }

                            {
                                exteriorDeckPremium.length > 0 ?
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="deckpremiumExterior" 
                                        name="cubiertaExterior"
                                        onClick={ () => loadOptionsExterior("DeckPremium") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="deckpremiumExterior" className="ml-2">DeckPremium</label>
                                </div> : ""
                            }
                            
                        </div>

                        {/*<div className="my-5">
                            <div className="bg-white rounded-md p-2">
                                <div className="flex justify-around items-center p-2">
                                    <div className="w-6/12">
                                        <label htmlFor="acabado" className="text-eGray font-MontserratSemiBold text-sm">Acabado: </label>
                                    </div>
                                    <div className="checkbox-wrapper-extras ml-3">
                                        <input type="checkbox" className="sc-gJwTLC ikxBAC focus:ring-[#eabb2e]" name="acabadoStatus" id="acabado" onChange={ e => !e.target.checked ? setShowAcabados("hidden") : setShowAcabados("") } />
                                    </div>
                                </div>
                                <div className={`flex justify-around items-center py-2 ${showAcabados}`}>
                                    <div className="flex items-center">
                                        <label htmlFor="lambrin" className="text-MontserratRegular text-eGray">Lambrín</label>
                                        <input type="radio" name="acabado" id="lambrin" className="ml-3" value="lambrin" />
                                    </div>
                                    <div className="flex items-center">
                                        <label htmlFor="deckpremium" className="text-MontserratRegular text-eGray">Deck Premium</label>
                                        <input type="radio" name="acabado" id="deckpremium" className="ml-3" value="deckpremium" />
                                    </div>
                                </div>
                            </div>
                        </div>*/}
                    </div>

                    <div className={`my-5 ${seleccionaTexturaInterior}`}>
                        <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Cubierta interior</p>
                        <div className="grid grid-cols-3 gap-2 mt-2">
                            {
                                interiorDeck.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="deckInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("Deck") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="deckInterior" className="ml-2">Deck</label>
                                </div> : ""
                            }

                            {
                                interiorMdf.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="mdfInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("MDF") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="mdfInterior" className="ml-2">MDF</label>
                                </div> : ""
                            }

                            {
                                interiorAlocubon.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="alocubonInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("Alocubon") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="alocubonInterior" className="ml-2">Alucubond</label>
                                </div> : ""
                            }

                            {
                                interiorAcero.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="aceroInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("Acero") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="aceroInterior" className="ml-2">Acero</label>
                                </div> : ""
                            }

                            {
                                interiorLumbrin.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="lumbrinInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("Lumbrin") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="lumbrinInterior" className="ml-2">Lumbrin</label>
                                </div> : ""
                            }

                            {
                                interiorPremium.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="premiumInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("Premium") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="premiumInterior" className="ml-2">Premium</label>
                                </div> : ""
                            }

                            {
                                interiorDeckPremium.length > 0 ? 
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-full">
                                    <input 
                                        type="radio" 
                                        id="deckpremiumInterior" 
                                        name="cubiertaInterior"
                                        onClick={ () => loadOptionsInterior("DeckPremium") } 
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="deckpremiumInterior" className="ml-2">DeckPremium</label>
                                </div> : ""
                            }
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaArmazon}`}>
                            <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Color de armazón</p>
                            <div className="flex gap-2 mt-2">
                                <div className="flex justify-start items-center bg-white border-solid rounded-md p-2 w-32">
                                    <input 
                                        type="radio" 
                                        id="armazonBlanco" 
                                        name="armazon"
                                        onClick={loadOptionsArmazon}  
                                        className="text-eYellow focus:ring-eYellow" />
                                    <label htmlFor="armazonBlanco" className="ml-2">Armazon</label>
                                </div>
                            </div>
                    </div>

                    <div className={`mt-10 ${seleccionaManija}`}>
                        <div onClick={e => loadOptionsManija(e)} className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                            <div>
                                <span className="text-eGray text-sm font-MontserratRegular">Agregar manija</span>
                            </div>
                            <div>
                                <img src={Go} alt="Puertas a medida" className="ml-2" />
                            </div>
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaManeral}`}>
                        <div onClick={e => loadOptionsManeral(e)} className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                            <div>
                                <span className="text-eGray text-sm font-MontserratRegular">Agregar maneral</span>
                            </div>
                            <div>
                                <img src={Go} alt="Puertas a medida" className="ml-2" />
                            </div>
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaDiseno}`}>
                        <div onClick={e => loadOptionsDiseno(e) } className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                            <div>
                                <span className="text-eGray text-sm font-MontserratRegular">Agregar diseño</span>
                            </div>
                            <div>
                                <img src={Go} alt="Puertas a medida" className="ml-2" />
                            </div>
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaCristal}`}>
                            <div onClick={e => loadOptionsCristal(e)} className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                                <div>
                                    <span className="text-eGray text-sm font-MontserratRegular">Agregar cristal</span>
                                </div>
                                <div>
                                    <img src={Go} alt="Puertas a medida" className="ml-2" />
                                </div>
                            </div>
                    </div>

                    <div className={`my-5 ${seleccionaCelosia}`}>
                        <div onClick={e => loadOptionsCelosia(e)} className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                            <div>
                                <span className="text-eGray text-sm font-MontserratRegular">Agregar celosia</span>
                            </div>
                            <div>
                                <img src={Go} alt="Puertas a medida" className="ml-2" />
                            </div>
                        </div>
                    </div>                    

                    <div className={`my-5 ${seleccionaApertura}`}>
                        <div className="flex items-center">
                            <p className="text-eGray uppercase font-MontserratSemiBold text-sm">selecciona dirección de apertura</p>
                            <Link to="/como-medir.pdf" target="_blank">
                                <span className="ml-3 bg-eYellow rounded-full px-2">
                                    <span className="text-white text-xs font-MontserratBold">?</span>
                                </span>
                            </Link>
                        </div>
                        <div className="grid grid-cols-2 gap-2 mt-2">
                            <div className="flex justify-start items-center bg-white border-solid rounded-md p-1 w-full">
                                <input 
                                    type="radio"  
                                    id="intIzquierda"
                                    name="apertura"
                                    onClick={ () => handleApertura("intIzq") } 
                                    className="text-eYellow focus:ring-eYellow" />
                                <label htmlFor="intIzquierda" className="ml-2">Int. Izquierda</label>
                            </div>
                            <div className="flex justify-start items-center bg-white border-solid rounded-md p-1 w-full">
                                <input 
                                    type="radio" 
                                    id="intDerecha"
                                    name="apertura"
                                    onClick={ () => handleApertura("intDer") } 
                                    className="text-eYellow focus:ring-eYellow" />
                                <label htmlFor="intDerecha" className="ml-2">Int. Derecha</label>
                            </div>
                        </div>
                        <div className="grid grid-cols-2 gap-2 mt-2">
                            <div className="flex justify-start items-center bg-white border-solid rounded-md p-1 w-full">
                                <input 
                                    type="radio"  
                                    id="extIzquierda"
                                    name="apertura"
                                    onClick={ () => handleApertura("extIzq") } 
                                    className="text-eYellow focus:ring-eYellow" />
                                <label htmlFor="extIzquierda" className="ml-2">Ext. Izquierda</label>
                            </div>
                            <div className="flex justify-start items-center bg-white border-solid rounded-md p-1 w-full">
                                <input 
                                    type="radio" 
                                    id="extDerecha"
                                    name="apertura"
                                    onClick={ () => handleApertura("extDer") } 
                                    className="text-eYellow focus:ring-eYellow" />
                                <label htmlFor="extDerecha" className="ml-2">Ext. Derecha</label>
                            </div>
                        </div>
                    </div>

                    <div className={`my-5 ${seleccionaApertura}`}>
                        <p className="text-eGray uppercase font-MontserratSemiBold text-sm">Extras</p>

                        <div className="my-5 ">
                            <div className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                                <div className="w-6/12">
                                    <label htmlFor="chambrana" className="text-eGray font-MontserratSemiBold text-sm">Chambrana: </label>
                                </div>
                                <div>
                                    <div className="checkbox-wrapper-extras ml-3">
                                        <input type="checkbox" className="sc-gJwTLC ikxBAC focus:ring-[#eabb2e]" name="chambrana" id="chambrana" onChange={ e => !e.target.checked ? setChambrana("no") : setChambrana("si") } />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div className="my-5 ">
                            <div className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                                <div className="w-6/12">
                                    <label htmlFor="mirilla" className="text-eGray font-MontserratSemiBold text-sm">Mirilla: </label>
                                </div>
                                <div>
                                    <div className="checkbox-wrapper-extras ml-3">
                                        <input type="checkbox" className="sc-gJwTLC ikxBAC focus:ring-[#eabb2e]" name="mirilla" id="mirilla" onChange={ e => !e.target.checked ? setMirilla("no") : setMirilla("si") } />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div className="my-5 ">
                            <div className="bg-white flex justify-around items-center py-2 border-solid rounded-md cursor">
                                <div className="w-6/12">
                                    <label htmlFor="cubrepolvo" className="text-eGray font-MontserratSemiBold text-sm">Cubrepolvo: </label>
                                </div>
                                <div>
                                    <div className="checkbox-wrapper-extras ml-3">
                                        <input type="checkbox" className="sc-gJwTLC ikxBAC focus:ring-[#eabb2e]" name="cubrepolvo" id="cubrepolvo" onChange={ e => !e.target.checked ? setCubrepolvo("no") : setCubrepolvo("si") } />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div className="my-5">
                            <div className="flex items-center">
                                <label className="text-eGray uppercase font-MontserratSemiBold text-sm">Mecanismo: </label>
                            </div>
                            <div className="flex justify-around items-center bg-white py-2 border-solid rounded-md my-5">
                                <div className="flex items-center w-6/12">
                                    <label htmlFor="pernos5" className="text-MontserratRegular text-eGray">5 pernos</label>
                                    <input type="radio" name="mecanismo" id="pernos5" className="ml-3" onChange={ e => e.target.checked ? setMecanismo("5") : "" } value="5" />
                                </div>
                                <div className="flex items-center">
                                    <label htmlFor="pernos8" className="text-MontserratRegular text-eGray">8 pernos</label>
                                    <input type="radio" name="mecanismo" id="pernos8" onChange={ e => e.target.checked ? setMecanismo("8") : "" } className="ml-3" value="8" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div className="lg:w-8/12 lg:flex justify-between h-[500px]">
                    <div className="w-full">
                        <div className="absolute flex justify-between items-center p-5" style={{right: "200px"}}>
                            {/*<p className="font-MontserratSemiBold uppercase text-center text-sm lg:text-lg text-eGray">Visualiza tu diseño</p>*/}
                            <button onClick={handleCheckout} className="bg-eYellow text-eGray font-MontserratSemiBold py-2 px-8 text-sm lg:text-base rounded-full">Ir a carrito</button>
                        </div>

                        <div className={`mt-24 ${displayPresentacion}`}>
                            <div className="lg:flex">
                                <div className="lg:w-6/12 flex justify-center items-center">
                                    <img src={Presentacion} alt="Puerta de ejemplo con fijo" width={250} height={400} />
                                </div>
                                <div className="lg:w-6/12 flex flex-col justify-center items-center p-5">
                                    <p className="font-MontserratSemiBold text-eGray mb-5">Elige las opciones que mejor se adecuen a tu proyecto:</p>
                                    <ol className="list-decimal font-MontserratRegular text-eGray">
                                        <li className="mt-2 ml-3">Ingresa las medidas</li>
                                        <li className="mt-2 ml-3">Elige tu tipo de apertura</li>
                                        <li className="mt-2 ml-3">Revisa las opciones y selecciona a tu gusto</li>
                                        <li className="mt-2 ml-3">¿Tienes dudas? Escríbenos a <Link className="text-eBlue" to="mailto:ventas@eversafe.com.mx" target="_blank">ventas@eversafe.com.mx</Link></li>
                                        <li className="mt-2 ml-3">¿Cómo elegir tu puerta? <Link className="bg-eYellow text-eBlack px-3 py-2 rounded-full" to="como-medir.pdf" target="_blank"> Descúbrelo aquí</Link></li>
                                    </ol>
                                </div>
                            </div>
                        </div>

                        <div className={`${displayConstruccion} flex justify-center items-end`}>
                            <div ref={ref} className="relative w-[500px] h-[500px]">
                                <div className={`${puertaBatientePreview}`}> {/**Puerta Batiente */}
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={texturaBatiente} alt="Textura" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={armazonBatiente} alt="Armazon" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={disenoBatiente} alt="Diseño" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={cristalBatiente} alt="Cristal" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={celosiaBatiente} alt="Celosia" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={maneralBatiente} alt="Maneral" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={manijaBatiente} alt="Manija" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={fijoBatiente} alt="Fijos" className={apertura} />
                                    </div>
                                </div>
                                <div className={`${puertaPivotePreview}`}> {/**Puerta Pivote */}
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={texturaPivote} alt="Textura" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={armazonPivote} alt="Armazon" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={disenoPivote} alt="Diseño" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={cristalPivote} alt="Cristal" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={celosiaPivote} alt="Celosia" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={maneralPivote} alt="Maneral" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={manijaPivote} alt="Manija" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={fijoPivote} alt="Fijos" className={apertura} />
                                    </div>
                                </div>
                                <div className={`${puertaFijoAbatiblePreview}`}> {/**Puerta FijoAbatible */}
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={texturaFijoAbatible} alt="Textura" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={armazonFijoAbatible} alt="Armazon" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={disenoFijoAbatible} alt="Diseño" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={cristalFijoAbatible} alt="Cristal" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={celosiaFijoAbatible} alt="Celosia" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={maneralFijoAbatible} alt="Maneral" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={manijaFijoAbatible} alt="Manija" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={fijoFijoAbatible} alt="Fijos" className={apertura} />
                                    </div>
                                </div>
                                <div className={`${puertaDoblePreview}`}> {/**Puerta Doble */}
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={texturaDoble} alt="Textura" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={armazonDoble} alt="Armazon" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={disenoDoble} alt="Diseño" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={cristalDoble} alt="Cristal" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={celosiaDoble} alt="Celosia" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={maneralDoble} alt="Maneral" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={manijaDoble} alt="Manija" className={apertura} />
                                    </div>
                                    <div className={`absolute top-0 left-0 w-[500px] h-[500px]`}>
                                        <img src={fijoDoble} alt="Fijos" className={apertura} />
                                    </div>
                                </div>
                            </div>

                            <div>
                                <div className={`${puertaBatientePreview} relative bg-eLightGray pt-3 border border- rounded-md border-[c0c0c0] top-auto bottom-0 left-auto right-0 w-[160px] h-[160px] overflow-hidden`}>
                                    <p className="font-MontserratSemiBold text-eGray text-center uppercase">Vista interior</p>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={texturaIntBatiente} alt="Textura" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={armazonBatiente} alt="Armazon" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-[5rem] top-[6rem]">
                                        <img src={FlechaInterior} alt="Flecha interior" width={37} height={28} />
                                    </div>
                                </div>
                                <div className={`${puertaPivotePreview} relative bg-eLightGray pt-3 border border- rounded-md border-[c0c0c0] top-auto bottom-0 left-auto right-0 w-[160px] h-[160px] overflow-hidden`}>
                                    <p className="font-MontserratSemiBold text-eGray text-center uppercase">Vista interior</p>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={texturaIntPivote} alt="Textura" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={armazonPivote} alt="Armazon" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-[6rem] top-[6rem]">
                                        <img src={FlechaInterior} alt="Flecha interior" width={37} height={28} />
                                    </div>
                                </div>
                                <div className={`${puertaFijoAbatiblePreview} relative bg-eLightGray pt-3 border border- rounded-md border-[c0c0c0] top-auto bottom-0 left-auto right-0 w-[160px] h-[160px] overflow-hidden`}>
                                    <p className="font-MontserratSemiBold text-eGray text-center uppercase">Vista interior</p>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={texturaIntFijoAbatible} alt="Textura" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={armazonFijoAbatible} alt="Armazon" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-[6.5rem] top-[6rem]">
                                        <img src={FlechaInterior} alt="Flecha interior" width={37} height={28} />
                                    </div>
                                </div>
                                <div className={`${puertaDoblePreview} relative bg-eLightGray pt-3 border border- rounded-md border-[c0c0c0] top-auto bottom-0 left-auto right-0 w-[160px] h-[160px] overflow-hidden`}>
                                    <p className="font-MontserratSemiBold text-eGray text-center uppercase">Vista interior</p>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={texturaIntDoble} alt="Textura" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-0 top-0 mt-3">
                                        <img src={armazonDoble} alt="Armazon" className={aperturaInvertida} />
                                    </div>
                                    <div className="absolute left-[6.5rem] top-[6rem]">
                                        <img src={FlechaInterior} alt="Flecha interior" width={37} height={28} />
                                    </div>
                                </div>

                                <div className="w-full text-center">
                                    <a 
                                        className="text-eBlack text-center font-MontserratLight text-sm"
                                        data-tooltip-id="tooltipVistaInterior" 
                                        data-tooltip-content="Es el diseño y estilo que quedará al reverso de la puerta, visto desde el interior."
                                    >
                                        ¿Qué es esto? &#9432;
                                    </a>
                                    <Tooltip place="bottom" id="tooltipVistaInterior" 
                                        render={({ content, activeAnchor }) => (
                                            <div className="w-72">
                                                <p className="text-center">{content}</p>
                                            </div>
                                        )}
                                    />
                                </div>
                            </div>
                        </div>
                    </div>

                    <div className="bg-eLightGray p-5">
                        <p className={`${listaOpciones} font-MontserratSemiBold uppercase text-start text-sm text-eGray`}>Selecciona una opción</p>

                        <div className="flex justify-center items-center">
                            <ListaOpcionesTexturaExterior
                                cubiertaExteriorOptionsShow={cubiertaExteriorOptionsShow}
                                base={base}
                                dataOpcionesExterior={dataOpcionesExterior}
                                configuracion={configuracion}
                                setTexturaBatiente={setTexturaBatiente}
                                setTexturaPivote={setTexturaPivote}
                                setTexturaFijoAbatible={setTexturaFijoAbatible}
                                setTexturaDoble={setTexturaDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesTexturaInterior
                                cubiertaInteriorOptionsShow={cubiertaInteriorOptionsShow}
                                base={base}
                                dataOpcionesInterior={dataOpcionesInterior}
                                setTexturaIntBatiente={setTexturaIntBatiente}
                                setTexturaIntPivote={setTexturaIntPivote}
                                setTexturaIntFijoAbatible={setTexturaIntFijoAbatible}
                                setTexturaIntDoble={setTexturaIntDoble}
                                configuracion={configuracion}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesArmazon 
                                armazonOptionsShow={armazonOptionsShow}
                                Empty={Empty}
                                dataOpcionesArmazon={dataOpcionesArmazon}
                                configuracion={configuracion}
                                setArmazonBatiente={setArmazonBatiente}
                                setArmazonPivote={setArmazonPivote}
                                setArmazonFijoAbatible={setArmazonFijoAbatible}
                                setArmazonDoble={setArmazonDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesDiseno 
                                disenoOptionsShow={disenoOptionsShow}
                                Empty={Empty}
                                dataOpcionesDiseno={dataOpcionesDiseno}
                                configuracion={configuracion}
                                setDisenoBatiente={setDisenoBatiente}
                                setDisenoPivote={setDisenoPivote}
                                setDisenoFijoAbatible={setDisenoFijoAbatible}
                                setDisenoDoble={setDisenoDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesCristal 
                                cristalOptionsShow={cristalOptionsShow}
                                Empty={Empty}
                                dataOpcionesCristal={dataOpcionesCristal}
                                configuracion={configuracion}
                                setCristalBatiente={setCristalBatiente}
                                setCristalPivote={setCristalPivote}
                                setCristalFijoAbatible={setCristalFijoAbatible}
                                setCristalDoble={setCristalDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesCelosia 
                                celosiaOptionsShow={celosiaOptionsShow}
                                Empty={Empty}
                                dataOpcionesCelosia={dataOpcionesCelosia}
                                configuracion={configuracion}
                                setCelosiaBatiente={setCelosiaBatiente}
                                setCelosiaPivote={setCelosiaPivote}
                                setCelosiaFijoAbatible={setCelosiaFijoAbatible}
                                setCelosiaDoble={setCelosiaDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            /> 

                            <ListaOpcionesManeral 
                                maneralOptionsShow={maneralOptionsShow}
                                Empty={Empty}
                                dataOpcionesManeral={dataOpcionesManeral}
                                configuracion={configuracion}
                                setManeralBatiente={setManeralBatiente}
                                setManeralPivote={setManeralPivote}
                                setManeralFijoAbatible={setManeralFijoAbatible}
                                setManeralDoble={setManeralDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesManija 
                                manijaOptionsShow={manijaOptionsShow}
                                Empty={Empty}
                                dataOpcionesManija={dataOpcionesManija}
                                configuracion={configuracion}
                                setManijaBatiente={setManijaBatiente}
                                setManijaPivote={setManijaPivote}
                                setManijaFijoAbatible={setManijaFijoAbatible}
                                setManijaDoble={setManijaDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />

                            <ListaOpcionesFijo 
                                fijoOptionsShow={fijoOptionsShow}
                                Empty={Empty}
                                dataOpcionesFijo={dataOpcionesFijo}
                                configuracion={configuracion}
                                configuracionFijo={configuracionFijo}
                                setFijoBatiente={setFijoBatiente}
                                setFijoPivote={setFijoPivote}
                                setFijoAbatible={setFijoAbatible}
                                setFijoDoble={setFijoDoble}
                                baseUrl={baseUrl}
                                puertaMedidaCarrito={puertaMedidaCarrito}
                                setPuertaMedidaCarrito={setPuertaMedidaCarrito}
                                design="h-[400px] overflow-hidden overflow-y-scroll flex-col"
                            />
                        </div>

                    </div>
                </div>
            </div>
        </main>
    )
}

export default PuertasMedidaWeb