import { Link } from "@remix-run/react"
import Youtube from "../../public/assets/img/yt-icon.webp"
import Facebook from "../../public/assets/img/fb-icon.webp"
import Go from "../../public/assets/img/go-icon.webp"
import Instagram from "../../public/assets/img/ig-icon.webp"
import Location from "../../public/assets/img/location-icon.webp"
import LogoFooter from "../../public/assets/img/logo-footer.webp"
import Phone from "../../public/assets/img/phone-icon.webp"
import Whatsapp from "../../public/assets/img/wapp-icon.webp"

const Footer = () => {
return (
        <div className="bg-eBlack py-10">
            <div className="lg:flex w-10/12 mx-auto">
                <div className="lg:w-1/4 my-5 lg:my-0 w-full flex flex-col justify-center items-center lg:justify-start lg:items-start">
                    <img src={LogoFooter} alt="Eversafe Logo" className="max-w-full mb-5" />
                    <p className="w-full text-center lg:text-start font-MontserratMedium text-eYellow uppercase">atención al cliente:</p>
                    <div className="w-full border-0">
                        <ul className="border-0 ">
                            <li className="text-center lg:text-start">
                                <a href="/Aviso-de-Privacidad.pdf" target="_blank" className="text-white font-MontserratMedium uppercase">aviso de privacidad</a>
                            </li>
                            <li className="text-center lg:text-start">
                            <a href="/Politica-de-compra.pdf" target="_blank" className="text-white font-MontserratMedium uppercase">politica de compra</a>
                            </li>
                            <li className="text-center lg:text-start">
                                <a href="/politica-de-devolucion.pdf" target="_blank" className="text-white font-MontserratMedium uppercase">politica de devolución</a>
                            </li>
                            <li className="text-center lg:text-start">
                                <a href="/terminos-y-condiciones.pdf" target="_blank" className="text-white font-MontserratMedium uppercase">terminos y condiciones</a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div className="lg:w-1/4 my-5 lg:my-0 flex flex-col justify-start items-center" id="sucursales">
                    <p className="w-full text-center lg:text-start font-MontserratMedium text-eYellow uppercase">nuestras sucursales:</p>
                    <div className="w-full border-0">
                        <ul className="border-0 ">
                            <li className="my-1">
                                <div className="flex justify-between items-center">
                                    <div className="flex justify-center items-center">
                                        <img src={Location} alt="Sucursal Contry" className="mr-2"/>
                                        <Link to="https://goo.gl/maps/aJoERStBhqh6JaN7A" target="_blank" className="text-white font-MontserratMedium uppercase">suc. contry</Link>
                                    </div>
                                    <img src={Go} alt="Ver sucursal" />
                                </div>
                            </li>
                            <li className="my-1">
                                <div className="flex justify-between items-center">
                                    <div className="flex justify-center items-center">
                                        <img src={Location} alt="Sucursal Contry" className="mr-2"/>
                                        <Link to="https://goo.gl/maps/ZuLqtLm2juuvNyua6" target="_blank" className="text-white font-MontserratMedium uppercase">suc. cumbres</Link>
                                    </div>
                                    <img src={Go} alt="Ver sucursal" />
                                </div>
                            </li>
                            <li className="my-1">
                                <div className="flex justify-between items-center">
                                    <div className="flex justify-center items-center">
                                        <img src={Location} alt="Sucursal Contry" className="mr-2"/>
                                        <Link to="https://goo.gl/maps/hxxj4CAACUmknRza7" target="_blank" className="text-white font-MontserratMedium uppercase">suc. valle</Link>
                                    </div>
                                    <img src={Go} alt="Ver sucursal" />
                                </div>
                            </li>
                            <li className="my-1">
                                <div className="flex justify-between items-center">
                                    <div className="flex justify-center items-center">
                                        <img src={Location} alt="Sucursal Contry" className="mr-2"/>
                                        <Link to="https://goo.gl/maps/cH3cz4gvgMg9n4Ys6" target="_blank" className="text-white font-MontserratMedium uppercase">suc.carretera nacional</Link>
                                    </div>
                                    <img src={Go} alt="Ver sucursal" />
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

                <div className="lg:w-1/4 my-5 lg:my-0 flex flex-col justify-start items-center">
                    <ul className="border-0 ">
                        <li className="my-1 w-full">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/quienes-somos" className="text-white font-MontserratMedium uppercase">Nosotros</Link>
                                </div>
                                <img src={Go} alt="Nosotros" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/nuestros-proyectos" className="text-white font-MontserratMedium uppercase">Proyectos</Link>
                                </div>
                                <img src={Go} alt="Proyectos" className="ml-2" />
                            </div>
                        </li>                    
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/puertas-a-medida" className="text-white font-MontserratMedium uppercase">puertas a tu medida</Link>
                                </div>
                                <img src={Go} alt="Puertas a medida" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/productos/seguridad" className="text-white font-MontserratMedium uppercase">puertas de seguridad</Link>
                                </div>
                                <img src={Go} alt="Puertas de seguridad" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/productos/acorazadas" className="text-white font-MontserratMedium uppercase">puertas acorazadas</Link>
                                </div>
                                <img src={Go} alt="Puertas de acorazadas" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/productos/antibalas" className="text-white font-MontserratMedium uppercase">puerta balística</Link>
                                </div>
                                <img src={Go} alt="Puertas balísticas" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/productos/deck" className="text-white font-MontserratMedium uppercase">deck</Link>
                                </div>
                                <img src={Go} alt="Deck" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/productos/otros-productos" className="text-white font-MontserratMedium uppercase">otros productos</Link>
                                </div>
                                <img src={Go} alt="Otros productos" className="ml-2" />
                            </div>
                        </li>
                        <li className="my-1">
                            <div className="flex justify-between items-center">
                                <div className="flex justify-center items-center">
                                    <Link to="/contacto" className="text-white font-MontserratMedium uppercase">Contacto</Link>
                                </div>
                                <img src={Go} alt="Contacto" className="ml-2" />
                            </div>
                        </li>
                    </ul>
                </div>

                <div className="lg:w-1/4 my-5 lg:my-0 flex flex-col justify-start items-center">
                    <p className="w-full text-center lg:text-start font-MontserratMedium text-eYellow uppercase">estamos al pendiente</p>
                    <div className="lg:w-full flex justify-center items-center pt-2">
                        <img src={Phone} alt="Telefono" className="mr-5" />
                        <p className="w-full font-MontserratRegular text-white uppercase">Tel. <a href="tel:+528138570899" target="_blank" >81 3857 0899</a></p>
                    </div>
                    <div className="w-full mt-2">
                        <p className="w-full text-center lg:text-start font-MontserratMedium text-eYellow uppercase mt-2">siguenos en redes sociales</p>
                        <div className="flex justify-around items-center mt-2">
                            <a href="https://www.facebook.com/PuertasEversafeMexico" target="_blank" >
                                <img src={Facebook} alt="Facebook"  />
                            </a>
                            <a href="https://www.instagram.com/eversafemx/" target="_blank" >
                                <img src={Instagram} alt="Instagram"  />
                            </a>
                            <a href="https://www.youtube.com/channel/UCnjCDflw4-hAYAvIFQFm_zg" target="_blank" >
                                <img src={Youtube} alt="Youtube"  />
                            </a>
                            <a href="https://wa.link/zen21g" target="_blank" >
                                <img src={Whatsapp} alt="Whatsapp"  />
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Footer