import { useEffect, useState } from "react"
import { Link, useLoaderData, useOutletContext } from "@remix-run/react"
import { ClientOnly } from "remix-utils"
import Swal from "sweetalert2"
import BackIcon from "../../public/assets/img/back-icon.webp"
import Paypal from "../../public/assets/img/paypal.png"
import MercadoPago from "../../public/assets/img/mercadopago.png"
import { generarId, numberWithCommas, validateEmail } from "~/helpers/functions"
import { getStates, getCities } from "~/models/checkout.server"
import styles from "../styles/main.css"

export async function loader() {
    const [ estados, ciudades ] = await Promise.all( [ getStates(), getCities() ] )
    loaderData = {
        estados: estados.data, 
        ciudades: ciudades.data, 
		baseUrlApi: process.env.API_URL
        
    }
    return loaderData
}

export function links() {
    return [
        {
            rel: 'stylesheet',
            href: styles
        }
    ]
}

const Checkout = () => {
    const loadedData = useLoaderData()
    const { estados, ciudades, baseUrlApi } = loadedData
    const [ showTarjeta, setShowTarjeta ] = useState("")
    const [ showPaypal, setShowPaypal ] = useState("hidden")
    const [ showMercadoPago, setShowMercadoPago ] = useState("hidden")
    const [ loading, setLoading ] = useState("hidden")
    const [ metodo, setMetodo ] = useState("hidden")
    const [ costoEntrega, setCostoEntrega ] = useState("000.00")

    const [ btnCredito, setBtnCredito ] = useState("bg-white border-2 border-eGray")
    const [ btnPaypal, setBtnPaypal ] = useState("bg-white border-2 border-eGray")
    const [ btnMercadoPago, setBtnMercadoPago ] = useState("bg-white border-2 border-eGray")

    const [ nombreIP, setNombreIP ] = useState("")
    const [ apellidoIP, setApellidoIP ] = useState("")
    const [ correoIP, setCorreoIP ] = useState("")
    const [ telefonoIP, setTelefonoIP ] = useState("")
    const [ direccionIP, setDireccionIP ] = useState("")
    const [ coloniaIP, setColoniaIP ] = useState("")
    const [ ciudadIP, setCiudadIP ] = useState("")
    const [ estadoIP, setEstadoIP ] = useState("")
    const [ listaCiudades, setListaCiudades ] = useState([])

    const [ nombreTarjeta, setNombreTarjeta ] = useState("")
    const [ tarjeta, setTarjeta ] = useState("")
    const [ vencimiento, setVencimiento ] = useState("")
    const [ cvv, setCVV ] = useState("")

    const [ pagarFlag, setPagarFlag ] = useState(false)

    const [ total, setTotal ] = useState(0)
    const [ promociones, setPromociones ] = useState(0.00)
    const { carrito, carritoMedida, cpEntrega, setCpEntrega } = useOutletContext()
    
    useEffect( ()  => {
        const filtro = ciudades.filter( item => {
            if ( estadoIP === item.vc_estado ) {
                return item
            }
        })
        setListaCiudades(filtro)
    }, [estadoIP])

    useEffect( () => {
        const calculotTotal = carrito?.reduce( (total, producto) => total + (producto.cantidad * Number(producto.precio.replace(",",""))), 0 )

        let totalSmart = 0
        carrito.forEach( item => {
            typeof item.smart.f_precio !== 'undefined' ?
                totalSmart = totalSmart + Number(item.smart.f_precio.replace(",",""))
            : ""
        })

        let totalPromociones = 0
        carrito.forEach( item => {
            totalPromociones = totalPromociones + Number(item.precio.replace(",",""))*((item.descuento/100))
        })

        carrito.forEach( item => {
            typeof item.smart.f_precio !== 'undefined' ?
                totalPromociones = totalPromociones + Number(item.smart.f_precio.replace(",",""))*((item.smart.i_descuento/100))
            : ""
        })

        setPromociones(totalPromociones)
        
        setTotal((calculotTotal+totalSmart).toFixed(2))
    }, [carrito])

    useEffect ( () => {
        if ( total === 0 && typeof carritoMedida[13] !== 'undefined' && carrito.length === 0 ) {
            setTotal(carritoMedida[13].totalPuertaMedida)
        }
    }, [carritoMedida])  

    const handleMethodPay = btn => {
        switch (btn){
            case "credito":
                setBtnPaypal("bg-white border-2 border-eGray")
                setShowPaypal("hidden")
                setBtnMercadoPago("bg-white border-2 border-eGray")
                setShowMercadoPago("hidden")

                setBtnCredito("bg-eBlack text-white border-4 border-eYellow")
                setShowTarjeta("")
                break
            case "paypal":
                setBtnCredito("bg-white border-2 border-eGray")
                setShowTarjeta("hidden")
                setBtnMercadoPago("bg-white border-2 border-eGray")
                setShowMercadoPago("hidden")

                setBtnPaypal("bg-eBlack text-white border-4 border-eYellow")
                setShowPaypal("")
                break
            case "mercadopago":
                setBtnCredito("bg-white border-2 border-eGray")
                setShowTarjeta("hidden")
                setBtnPaypal("bg-white border-2 border-eGray")
                setShowPaypal("hidden")

                setBtnMercadoPago("bg-eBlack text-white border-4 border-eYellow")
                setShowMercadoPago("")
                break
            default:
                setBtnCredito("bg-white border-2 border-eGray")
        }
    }

    const handleCalcular = async () => {
        let lista = {}
        setMetodo("hidden")
        setPagarFlag(true)
        setLoading("")
        if( cpEntrega === "" ) {
            setLoading("hidden")
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Código postal' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else {
            if ( carrito.length > 0 ){
                lista = carrito.map( value => {
                    if( typeof value.smart.id !== "undefined" ) {
                        return [
                            {
                                puertaMedida: 0,
                                cantidad: value.cantidad, 
                                cat: value.cat, 
                                id: value.id, 
                                precio: value.precio,
                                smart: value.smart.id, 
                                cp: cpEntrega
                            }
                        ]
                    } else {
                        return [
                            {
                                puertaMedida: 0,
                                cantidad: value.cantidad, 
                                cat: value.cat, 
                                id: value.id, 
                                precio: value.precio, 
                                cp: cpEntrega
                            }
                        ]
                    }  
                })
            } else if ( carritoMedida.length > 0 ) {
                lista = [
                    {
                        puertaMedida: 1,
                        cantidad: 1, 
                        alto: carritoMedida[14].medidaAlto, 
                        ancho: carritoMedida[14].medidaAncho, 
                        pesoFijo: carritoMedida[14].fijosPeso,
                        pesoPuerta: carritoMedida[14].puertaPeso,
                        precio: carritoMedida[13].totalPuertaMedida, 
                        cp: cpEntrega
                    }
                ]
            }            
            
            const options = {
                method: 'POST',
                headers: {
                accept: 'application/vnd.conekta-v2.1.0+json',
                'content-type': 'application/json',
                },
                body: JSON.stringify({
                    calculoEnvio: lista
                })
            }
            const respuesta = await fetch(`${baseUrlApi}/conekta/get-estimation`, options)
            const resp = await respuesta.json()
            if ( resp.data.return.error !== "" ) {
                Swal.fire({
                    title: "<h2>¡Error!</h2>",
                    html: "El costo de la entrega no pudo ser calculado.",
                    icon: 'error',
                    confirmButtonText: ' Cerrar ',
                    confirmButtonColor: '#eabb2e',
                })
            } else {
                setCostoEntrega(resp.data.return.total)
                setMetodo("")
            }
            setPagarFlag(false)
            setLoading("hidden")
        }
    }

    const handleToken = async e => { 
        setPagarFlag(true)
        setLoading("")
        e.preventDefault()
        if( nombreIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Nombre' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( apellidoIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Apellido' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( correoIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Correo' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( !validateEmail(correoIP) ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Correo' no es válido",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( telefonoIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Teléfono' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( telefonoIP.length < 10 ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Teléfono' debe contener 10 dígitos",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( direccionIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Dirección' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( coloniaIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Colonia' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( ciudadIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Ciudad' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( estadoIP === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Estado' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( cpEntrega === "" ) {
            setLoading("hidden")
            setPagarFlag(false)
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Código postal' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( nombreTarjeta === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Nombre en tarjeta' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( tarjeta === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Tarjeta' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( vencimiento === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Vencimiento' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( cvv === "" ) {
            setPagarFlag(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'CVV' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else {
            Swal.fire({
                title: 'Procesando el pago!',
                html: 'Espere mientras se realiza el cobro <b></b>.',
                timer: 60000,
                timerProgressBar: true,
                didOpen: () => {
                  Swal.showLoading()
                  const b = Swal.getHtmlContainer().querySelector('b')
                  const timerInterval = setInterval(() => {
                    b.textContent = Swal.getTimerLeft()/1000
                  }, 100)
                },
                willClose: () => {
                  //clearInterval(timerInterval)
                }
            }).then((result) => {
                /* Read more about handling dismissals below */
                if (result.dismiss === Swal.DismissReason.timer) {
                    //
                }
            })
              
            Conekta.setPublicKey("key_TegL7zC0FxDC3laJwxUKmNy")

            const expire = vencimiento.split("/")
            
            let card_info = {
                "card": {
                    "name": nombreTarjeta,
                    "number": tarjeta, 
                    "exp_month": expire[0],
                    "exp_year": expire[1],
                    "cvc": cvv, 
                }
            }
            
            // send info
            //try{
            Conekta.Token.create(card_info, function(response) {
                    const token = response.id
                    //
                    const options = {
                        method: 'POST',
                        headers: {
                        accept: 'application/vnd.conekta-v2.1.0+json',
                        'content-type': 'application/json',
                        },
                        body: JSON.stringify({
                            payData: {
                                token, 
                                nombreIP, 
                                apellidoIP, 
                                correoIP, 
                                telefonoIP, 
                                direccionIP, 
                                coloniaIP, 
                                ciudadIP, 
                                estadoIP, 
                                cpIP: cpEntrega, 
                                tarjeta, 
                                nombreTarjeta,
                                subtotal: total, 
                                entrega: costoEntrega,
                                promociones: promociones,
                                total: total - promociones, 
                                carrito, 
                                carritoMedida
                            }
                        })
                    }

                    const cobrar = async() => {
                        await fetch(baseUrlApi+'/conekta/simple-pay', options)
                        .then(response => response.json())
                        .then(response => {
                            if ( response.error ) {
                                Swal.fire({
                                    title: "<h2>¡Validación!</h2>",
                                    html: response.message,
                                    icon: 'warning',
                                    confirmButtonText: 'Cerrar',
                                    confirmButtonColor: '#eabb2e',
                                })
                                setPagarFlag(false)
                                setLoading("hidden")
                            } else {
                                window.location.href = "compra-finalizada"
                                setPagarFlag(false)
                                setLoading("hidden")
                            }
                        })
                        .catch(err => console.error("errorConekta: ", err))
                    }                 
                    cobrar()
                    setPagarFlag(false)
                    setLoading("hidden")
                }, function(response) {
                    if ( response.object === "error" ) {
                        Swal.close()
                        setPagarFlag(false)
                        setLoading("hidden")

                        Swal.fire({
                            title: "<h2>¡Validación!</h2>",
                            html: "Los datos de la tarjeta son incorrectos",
                            icon: 'warning',
                            confirmButtonText: ' Cerrar ',
                            confirmButtonColor: '#eabb2e',
                        })
                    }
                }
            )
        }
    }

    const handleVencimiento = e => {
        if ( e.length < 6 ){ 
            if ( e.length === 2 ){
                setVencimiento(e + "/")
            } else {
                setVencimiento(e)
            }
        }
    }

    return (
        <ClientOnly fallback={'Cargando...'}>
            { () => (
                <div className="bg-eLightGray">
                    <section className="lg:flex">
                        <div className="lg:w-8/12 lg:pl-28 lg:pr-10 px-10 py-20  bg-white">
                            <div className="flex flex-col lg:flex-row justify-between items-center gap-2">
                                <p className="text-eBlack font-MontserratBold text-2xl text-center lg:text-start">1. Información personal</p>
                                <div className="flex justify-center items-center gap-2">
                                    <img src={BackIcon} alt="Regresar a productos" />
                                    <Link className="text-eBlue" to="/carrito">Volver al carrito</Link>
                                </div>
                            </div>

                            <hr className="my-10" />

                            <div className="lg:flex gap-5 my-5 lg:w-8/12">
                                <div className="lg:w-6/12">
                                    <label className="mb-5" htmlFor="nombre">Nombre:</label>
                                    <input 
                                        type="text" 
                                        value={nombreIP}
                                        onChange={ e => setNombreIP(e.target.value) } 
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="Escribe tu nombre" />
                                </div>
                                <div className="lg:w-6/12">
                                    <label className="mb-5 mt-2" htmlFor="apellido">Apellido:</label>
                                    <input 
                                        type="text" 
                                        value={apellidoIP}
                                        onChange={ e => setApellidoIP(e.target.value) }  
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="Escribe tu apellido" />
                                </div>
                            </div>
                            <div className="lg:flex gap-5 my-5 lg:w-8/12">
                                <div className="w-full">
                                    <label className="mb-5" htmlFor="correo">Correo electrónico</label>
                                    <input 
                                        type="text" 
                                        value={correoIP}
                                        onChange={ e => setCorreoIP(e.target.value) } 
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="correo@ejemplo.com" />
                                </div>
                            </div>
                            <div className="lg:flex gap-5 my-5 lg:w-8/12">
                                <div className="w-full">
                                    <label className="mb-5" htmlFor="telefono">Teléfono:</label>
                                    <input 
                                        type="text" 
                                        value={telefonoIP}
                                        onChange={ e => setTelefonoIP(e.target.value) }  
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="+52 00 0000 0000" />
                                </div>
                            </div>
                            <div className="lg:flex gap-5 mt-10 mb-5 lg:w-8/12">
                                <div className="w-full">
                                    <label className="mb-5" htmlFor="direccion">Dirección:</label>
                                    <input 
                                        type="text" 
                                        value={direccionIP}
                                        onChange={ e => setDireccionIP(e.target.value) }  
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="Calle y número" />
                                </div>
                            </div>
                            <div className="lg:flex gap-5 my-5 lg:w-8/12">
                                <div className="lg:w-6/12">
                                    <label className="mb-5 mt-2" htmlFor="estado">Estado:</label>
                                    <select type="text" value={estadoIP} onChange={ e => setEstadoIP(e.target.value) } className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" >
                                        <option value="">Selecciona</option>
                                        {
                                            estados?.map( est => (
                                                <option key={generarId()} value={est.vc_estado}>{est.vc_estado}</option>
                                            ))
                                        }
                                    </select>
                                </div>
                                <div className="lg:w-6/12">
                                    <label className="mb-5 mt-2" htmlFor="ciudad">Ciudad:</label>
                                    <select type="text" value={ciudadIP} onChange={ e => setCiudadIP(e.target.value) }  className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" >
                                        <option value="">Selecciona</option>
                                        {
                                            listaCiudades?.map(item => (
                                                <option key={generarId()} value={item.vc_municipio}>{item.vc_municipio}</option>
                                            ))
                                        }
                                    </select>
                                </div>                                
                            </div>
                            <div className="lg:flex gap-5 my-5 lg:w-8/12">
                                <div className="lg:w-6/12">
                                    <label className="mb-5" htmlFor="colonia">Colonia:</label>
                                    <input 
                                        type="text" 
                                        value={coloniaIP}
                                        onChange={ e => setColoniaIP(e.target.value) }  
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="Escribe tu colonia" />
                                </div>
                                <div className="lg:w-6/12">
                                    <label className="mb-5" htmlFor="cp">Código Postal:</label>
                                    <input 
                                        type="text" 
                                        value={cpEntrega}
                                        onChange={ e => setCpEntrega(e.target.value) }  
                                        className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                        placeholder="00000" />
                                </div>
                            </div>
                            {/*<div className="flex gap-5 justify-start items-center">
                                <input type="checkbox" id="facturacionEntrega" />
                                <label htmlFor="facturacionEntrega">Dirección de facturación igual a la de entrega</label>
                            </div>*/}

                            <div className="flex lg:w-8/12 gap-5 justify-end  items-center">
                                <button 
                                    type="button" 
                                    onClick={handleCalcular}
                                    disabled={pagarFlag}
                                    className="flex border-0 bg-eYellow text-xl text-eBlack py-2 px-5 rounded-md"
                                >
                                    Calcular envío
                                    <span className={`${loading} relative flex h-3 w-3`}>
                                        <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-white opacity-75"></span>
                                        <span className="relative inline-flex rounded-full h-3 w-3 bg-white"></span>
                                    </span>
                                </button>
                            </div>

                            <div className={metodo}>
                                <div className="flex justify-between items-center mt-10">
                                    <p className="text-eBlack font-MontserratBold text-2xl">2. Método de pago</p>
                                </div>

                                <hr className="my-10" />

                                {/*<div className="lg:flex justify-between items-center lg:w-8/12">
                                    <div>
                                    </div>
                                        <button onClick={() => handleMethodPay('credito')} className={`w-full lg:w-40 my-2 py-2 px-5 rounded-md ${btnCredito}`}>Crédito/Débito</button>
                                    <div>
                                        <button onClick={() => handleMethodPay('paypal')} className={`w-full lg:w-40 my-2 py-2 px-5 rounded-md ${btnPaypal}`}>PayPal</button>
                                    </div>
                                    <div>
                                        <button onClick={() => handleMethodPay('mercadopago')} className={`w-full lg:w-40 my-2 py-2 px-5 rounded-md ${btnMercadoPago}`}>Mercado Pago</button>
                                    </div>
                                </div>*/}

                                <div className="lg:w-8/12"></div>

                                <div id="pagoTarjeta" className={`${showTarjeta}`}>
                                    <form onSubmit={handleToken}>
                                        <div className="lg:flex gap-5 mt-10 mb-5 lg:w-8/12">
                                            <div className="w-full">
                                                <label className="mb-5" htmlFor="nTarjeta">Nombre en tarjeta:</label>
                                                <input 
                                                    id="nombreTarjeta"
                                                    type="text" 
                                                    value={nombreTarjeta}
                                                    onChange={ e => setNombreTarjeta(e.target.value) } 
                                                    className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                                    placeholder="Escribe aquí el nombre en la tarjeta" />
                                            </div>
                                        </div>

                                        <div className="lg:flex gap-5 mt-5 mb-5 lg:w-8/12">
                                            <div className="w-full">
                                                <label className="mb-5" htmlFor="tarjeta">Número de tarjeta:</label>
                                                <input 
                                                    id="tarjeta"
                                                    type="text" 
                                                    value={tarjeta}
                                                    onChange={ e => setTarjeta(e.target.value) } 
                                                    className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                                    placeholder="Escribe aquí el número de tarjeta" />
                                            </div>
                                        </div>

                                        <div className="lg:flex gap-3 my-5 lg:w-8/12">
                                            <div className="lg:w-6/12">
                                                <label className="mb-5" htmlFor="vencimiento">Vencimiento:</label>
                                                <input 
                                                    type="text" 
                                                    value={vencimiento}
                                                    onChange={ e => handleVencimiento(e.target.value) } 
                                                    className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                                    placeholder="MM / AA" />
                                            </div>
                                            <div className="lg:w-6/12">
                                                <label className="mb-5 mt-5" htmlFor="cvv">Código de seguridad:</label>
                                                <input 
                                                    type="password" 
                                                    value={cvv}
                                                    onChange={ e => setCVV(e.target.value) } 
                                                    className="w-full border-2 bg-eLightGray border-eLightGray focus:border-eYellow focus:ring-0 rounded-md px-5" 
                                                    placeholder="cvv" />
                                            </div>
                                        </div>

                                        <div className="lg:flex lg:justify-end justify-center items-center mt-10 lg:w-8/12">
                                            <button 
                                                type="submit" 
                                                disabled={pagarFlag} 
                                                className="flex border-0 bg-eYellow text-xl text-eBlack py-3 px-6 rounded-md"
                                            >
                                                Proceder al pago
                                                <span className={`${loading} relative flex h-3 w-3`}>
                                                    <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-white opacity-75"></span>
                                                    <span className="relative inline-flex rounded-full h-3 w-3 bg-white"></span>
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                </div>

                                <div id="pagoPaypal" className={`${showPaypal}`}>
                                    <img src={Paypal} alt="Pago con Paypal" />
                                </div>

                                <div id="pagoMercadoPago" className={`${showMercadoPago}`}>
                                    <img src={MercadoPago} alt="Pago con MercadoPago" />
                                </div>
                            
                            </div>

                        </div>
                        <div className="lg:w-4/12 bg-eLightGray py-20 px-10">
                            <div className="sticky top-0">
                                <p className="text-2xl font-MontserratSemiBold text-eGray">Producto(s):</p>
                                <hr className="my-10" />

                                {
                                    carrito?.length !== 0 ? (
                                        carrito?.map( producto => (
                                            <div key={producto.id}>
                                                <div className="lg:flex justify-between items-center my-10">
                                                    <p className="font-MontserratLight">x{producto.cantidad}:</p>
                                                    <p className="font-MontserratSemiBold text-eGray">{producto.puerta} {producto.modelo}</p>
                                                </div>
                                                {
                                                    typeof producto.smart.id === 'undefined' ? "" :
                                                    <div className="lg:flex justify-between items-center my-10">
                                                        <p className="font-MontserratLight">x1:</p>
                                                        <p className="font-MontserratSemiBold text-eGray">{producto.smart.vc_producto}</p>
                                                    </div>
                                                }
                                            </div>
                                        ))
                                    ) : carritoMedida?.length !== 0 ? (
                                        <div>
                                            <div className="lg:flex justify-between items-center my-10">
                                                <p className="font-MontserratLight">x1:</p>
                                                <p className="font-MontserratSemiBold text-eGray">Puerta a la medida</p>
                                            </div>
                                        </div>
                                    ) : "No hay elementos"
                                }

                                <p className="text-2xl font-MontserratSemiBold text-eGray">Resumen:</p>
                                <hr className="my-10" />
                                <div className="lg:flex justify-between items-center my-10">
                                    <p className="font-MontserratLight">Subtotal:</p>
                                    <p className="font-MontserratSemiBold text-eGray">${numberWithCommas(total)}</p>
                                </div>
                                <div className="lg:flex justify-between items-center my-10">
                                    <p className="font-MontserratLight">Entrega:</p>
                                    <p className="font-MontserratSemiBold text-eGray">${costoEntrega}</p>
                                </div>
                                <div className="lg:flex justify-between items-center my-10">
                                    <p className="font-MontserratLight">Promociones:</p>
                                    <p className="font-MontserratSemiBold text-eGray">$-{numberWithCommas(promociones)}</p>
                                </div>
                                <hr className="my-10" />
                                <div className="lg:flex justify-between items-center">
                                    <p className="font-MontserratLight text-eGray uppercase">total:</p>
                                    <div className="flex justify-center items-center gap-2">
                                        <span className="text-sm font-MontserratLight">MXN</span>
                                        <p className="font-MontserratSemiBold text-eGray">${numberWithCommas((+total + +costoEntrega - +promociones).toFixed(2))}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            ) }
        </ClientOnly>
    )
}

export default Checkout
