import Banner from "../../public/assets/img/nosotros-header.webp"
import Logo from "../../public/assets/img/logo.webp"
import Mision from "../../public/assets/img/icon-mision.webp"
import Vision from "../../public/assets/img/icon-vision.webp"
import Innovacion from "../../public/assets/img/05icon-innova.webp"
import Etica from "../../public/assets/img/01icon-etica.webp"
import Honestidad from "../../public/assets/img/02icon-hones.webp"
import Compromiso from "../../public/assets/img/03icon-compr.webp"
import Calidad from "../../public/assets/img/04icon-calidad.webp"
import Fortaleza from "../../public/assets/img/icon-fortaleza.webp"
import Socios1 from "../../public/assets/img/logo01.webp"
import Socios2 from "../../public/assets/img/logo02.webp"
import Socios3 from "../../public/assets/img/logo03.webp"
import Socios4 from "../../public/assets/img/logo04.webp"
import Sucursales from "../../public/assets/img/cintillo2.webp"

const QuienesSomos = () => {
    return (
        <>
            <section>
                <div className="relative">
                    <img src={Banner} alt="¿Quienes somos?" />
                    <div className="absolute top-2 left-2 lg:top-1/4 lg:left-28">
                        <div className="w-8/12">
                            <h1 className="lg:text-6xl text-eBlue">
                                <span className="bg-white px-2">¿QUIÉNES</span>
                                <br />
                                <span className="text-white">SOMOS?</span>
                            </h1>
                            <p className="text-xs lg:text-base text-white mt-3 lg:mt-6 font-MontserratRegular">Conoce sobre Eversafe y lo que nos impulsa a darte el mejor servicio</p>
                        </div>
                    </div>
                </div>
            </section>
            
            <section>
                <div className="containter lg:w-10/12 mx-auto py-10 lg:py-20">
                    <div className="lg:flex">
                        <div className="flex flex-col justify-start items-start lg:w-6/12 p-8">
                            <img src={Logo} alt="logo" />
                            <p className="mt-7 lg:mt-14 text-2xl lg:text-3xl text-eGray leading-10">Somos una empresa <span className="text-eBlue">enfocada en la fabricación de productos para las industrias de retail, gas, construcción y automotriz.</span> Tenemos más de 25 años de experiencia sirviendo a OEM de todo el mundo y 10 años en el mercado retail.</p>
                        </div>
                        <div className="lg:w-6/12 p-8">
                            <p className="font-MontserratRegular ">Eversafe, empresa dedicada a satisfacer las necesidades de nuestros distribuidores, con el fin de brindar la mejor calidad y servicio en cada uno de nuestros productos.<br /><br />Nuestras puertas Eversafe, además de ofrecer diseños vanguardistas, también protege tu casa, familia y negocio contra la inseguridad del país. Al adquirir un producto con nosotros adquieres servicio, asesoría y sobre todo el respaldo de una compañía comprometida.<br /><br />Hoy en día contamos con una gran variedad de productos para la seguridad de tu hogar, como lo es, puertas acorazadas, puertas de grado balístico, protectores para ventana, alarmas y cerraduras digitales.<br /><br />Actualmente, nuestros productos también los puedes encontrar en MN del Golfo, ELYSA, Coppel y HEB.<br /><br />Contamos con un equipo profesional de instaladores, vendedores y de atención al cliente; siempre resolveremos tus necesidades de seguridad, encontrando en nosotros una solución total.</p>
                        </div>
                    </div>
                </div>
            </section>
            
            <section className="bg-eLightGray py-20 lg:px-20">
                <div className="lg:flex mx-auto w-full">
                    <div className="flex flex-col justify-center items-center lg:w-6/12 p-5">
                        <img src={Mision} alt="Misión" width={80} />
                        <p className="text-center text-eBlue font-MontserratSemiBold my-5">Misión</p>
                        <p className="text-center text-eGray font-MontserratRegular">Seguir creando y distribuyendo productos de calidad, con el firme objetivo de cumplir con las necesidades y expectativas de nuestros distribuidores.</p>
                    </div>
                    <div className="flex flex-col justify-center items-center lg:w-6/12 p-5">
                        <img src={Vision} alt="Misión" width={80} />
                        <p className="text-center text-eBlue font-MontserratSemiBold my-5">Visión</p>
                        <p className="text-center text-eGray font-MontserratRegular">Posicionarnos como la empresa número uno de distribución de puertas de seguridad a nivel nacional.</p>
                    </div>
                </div>

                <div className="grid grid-cols-2 lg:flex w-full mt-20">
                    <div className="flex w-full justify-center items-center">
                        <p className="text-2xl text-eGray uppercase font-MontserratSemiBold">Valores:</p>
                    </div>
                    <div className="flex w-full flex-col justify-center items-center">
                        <img src={Etica} alt="Ética" height={80} className="mb-4" />
                        <p className="text-center text-eGray font-MontserratSemiBold uppercase">Ética</p>
                    </div>
                    <div className="flex w-full flex-col justify-center items-center">
                        <img src={Honestidad} alt="Honestidad" height={80} className="mb-4" />
                        <p className="text-center text-eGray font-MontserratSemiBold uppercase">Honestidad</p>
                    </div>
                    <div className="flex w-full flex-col justify-center items-center">
                        <img src={Compromiso} alt="Compromiso" height={80} className="mb-4" />
                        <p className="text-center text-eGray font-MontserratSemiBold uppercase">Compromiso</p>
                    </div>
                    <div className="flex w-full flex-col justify-center items-center">
                        <img src={Calidad} alt="Calidad" height={80} className="mb-4" />
                        <p className="text-center text-eGray font-MontserratSemiBold uppercase">Calidad</p>
                    </div>
                    <div className="flex w-full flex-col justify-center items-center">
                        <img src={Innovacion} alt="Innovación" height={80} className="mb-4" />
                        <p className="text-center text-eGray font-MontserratSemiBold uppercase">Innovación</p>
                    </div>
                </div>
            </section>
            
            <section className="px-2 lg:px-10 py-20 bg-backFortalezas bg-center bg-no-repeat bg-cover">
                <div className="container lg:w-10/12 mx-auto">
                    <div className="bg-white lg:w-7/12 p-5 lg:p-10">
                        <div className="flex justify-center lg:justify-start items-center mb-10">
                            <img src={Fortaleza} alt="nuestras fortalezas" width={80} />
                            <p className="ml-5 text-2xl lg:text-4xl text-eGray font-MontserratSemiBold uppercase">nuestras fortalezas</p>
                        </div>
                        <ul> 
                            <li className="bg-checkFortalezas bg-no-repeat pl-10 my-4 font-MontserratRegular">PERSONALIZAR EL DESARROLLO DE PRODUCTOS DE ACUERDO A LOS REQUERIMIENTOS DEL CLIENTE.</li>
                            <li className="bg-checkFortalezas bg-no-repeat pl-10 my-4 font-MontserratRegular">DISEÑO Y FABRICACIÓN DE NUESTROS PROPIOS EXHIBIDORES Y POP.</li>
                            <li className="bg-checkFortalezas bg-no-repeat pl-10 my-4 font-MontserratRegular">ENVÍOS 24/7.</li>
                            <li className="bg-checkFortalezas bg-no-repeat pl-10 my-4 font-MontserratRegular">STOCK DE SEGURIDAD DE MATERIA PRIMA Y PRODUCTO TERMINADO PARA NUESTROS CLIENTES.</li>
                            <li className="bg-checkFortalezas bg-no-repeat pl-10 my-4 font-MontserratRegular">ATENCIÓN AL CLIENTE EN TODO MÉXICO.</li>
                            <li className="bg-checkFortalezas bg-no-repeat pl-10 my-4 font-MontserratRegular">SERVICIO POSVENTA DE REPUESTOS Y SOPORTE TÉCNICO.</li>
                        </ul>
                    </div>
                </div>
            </section>
            
            <section className="py-20">
                <p className="text-4xl text-eGray text-center mb-10">Hacemos mancuerna con los <span className="text-eBlue">mejores socios comerciales:</span></p>

                <div className="container w-10/12 mx-auto">
                    <div className="w-full grid grid-cols-2 lg:flex justify-center items-center">
                        <div className="w-full p-3 flex justify-center items-center">
                            <img src={Socios1} alt="Home Depot" />
                        </div>
                        <div className="w-full p-3 flex justify-center items-center">
                            <img src={Socios2} alt="Costco" />
                        </div>
                        <div className="w-full p-3 flex justify-center items-center">
                            <img src={Socios3} alt="Liverpool" />
                        </div>
                        <div className="w-full p-3 flex justify-center items-center">
                            <img src={Socios4} alt="HEB" />
                        </div>
                    </div>
                </div>

                <div className="container w-10/12 mx-auto mt-20">
                    <img src={Sucursales} alt="Sucursales" />
                </div>
            </section>
        </>
    )
}

export default QuienesSomos
