import type esbuild from "esbuild";
import type { RemixConfig } from "../config";
import type { AssetsManifest } from "./assets";
import type { BrowserCompiler } from "./compileBrowser";
import type { ServerCompiler } from "./compilerServer";
import type { OnCompileFailure } from "./onCompileFailure";
import type { CompileOptions } from "./options";
type RemixCompiler = {
    browser: BrowserCompiler;
    server: ServerCompiler;
};
export declare const createRemixCompiler: (remixConfig: RemixConfig, options: CompileOptions) => RemixCompiler;
export type CompileResult = {
    assetsManifest: AssetsManifest;
    metafile: {
        browser: esbuild.Metafile;
        server: esbuild.Metafile;
    };
};
export declare const compile: (compiler: RemixCompiler, options?: {
    onCompileFailure?: OnCompileFailure;
}) => Promise<CompileResult | undefined>;
export declare const dispose: (compiler: RemixCompiler) => void;
export {};
