"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const ButtonGroup = ({ children, className, outline, pill, theme: customTheme = {}, ...props }) => {
    const items = (0, react_1.useMemo)(() => react_1.Children.map(children, (child, index) => (0, react_1.cloneElement)(child, {
        outline,
        pill,
        positionInGroup: index === 0 ? 'start' : index === children.length - 1 ? 'end' : 'middle',
    })), [children, outline, pill]);
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.buttonGroup, customTheme);
    return ((0, jsx_runtime_1.jsx)("div", { className: (0, classnames_1.default)(theme.base, className), role: "group", ...props, children: items }));
};
ButtonGroup.displayName = 'Button.Group';
exports.default = ButtonGroup;
