"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DarkThemeToggle = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const hi_1 = require("react-icons/hi");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const DarkThemeToggle = ({ className, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.darkThemeToggle, customTheme);
    const { mode, toggleMode } = (0, react_1.useContext)(ThemeContext_1.ThemeContext);
    return ((0, jsx_runtime_1.jsx)("button", { "aria-label": "Toggle dark mode", "data-testid": "dark-theme-toggle", onClick: toggleMode, type: "button", className: (0, classnames_1.default)(theme.root.base, className), ...props, children: mode === 'dark' ? ((0, jsx_runtime_1.jsx)(hi_1.HiSun, { "aria-label": "Currently dark mode", className: theme.root.icon })) : ((0, jsx_runtime_1.jsx)(hi_1.HiMoon, { "aria-label": "Currently light mode", className: theme.root.icon })) }));
};
exports.DarkThemeToggle = DarkThemeToggle;
