"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListGroup = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const ListGroupItem_1 = require("./ListGroupItem");
const ListGroupComponent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.listGroup, customTheme);
    return ((0, jsx_runtime_1.jsx)("ul", { className: (0, classnames_1.default)(theme.root.base, className), ...props, children: children }));
};
ListGroupComponent.displayName = 'ListGroup';
ListGroupItem_1.ListGroupItem.displayName = 'ListGroup.Item';
exports.ListGroup = Object.assign(ListGroupComponent, { Item: ListGroupItem_1.ListGroupItem });
