"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const Badge_1 = require("../Badge");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const Tooltip_1 = require("../Tooltip");
const SidebarContext_1 = require("./SidebarContext");
const SidebarItemContext_1 = require("./SidebarItemContext");
const ListItem = ({ id, isCollapsed, tooltipChildren, children: wrapperChildren, }) => ((0, jsx_runtime_1.jsx)("li", { children: isCollapsed ? ((0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, { content: (0, jsx_runtime_1.jsx)(TooltipContent, { id: id, children: tooltipChildren }), placement: "right", children: wrapperChildren })) : (wrapperChildren) }));
const TooltipContent = ({ id, children }) => ((0, jsx_runtime_1.jsx)(Children, { id: id, children: children }));
const Children = ({ id, children }) => {
    const theme = (0, ThemeContext_1.useTheme)().theme.sidebar.item;
    return ((0, jsx_runtime_1.jsx)("span", { "data-testid": "flowbite-sidebar-item-content", id: `flowbite-sidebar-item-${id}`, className: (0, classnames_1.default)(theme.content.base), children: children }));
};
const SidebarItem = (0, react_1.forwardRef)(({ active: isActive, as: Component = 'a', children, className, icon: Icon, label, labelColor = 'info', theme: customTheme = {}, ...props }, ref) => {
    const id = (0, react_1.useId)();
    const { isCollapsed } = (0, SidebarContext_1.useSidebarContext)();
    const { isInsideCollapse } = (0, SidebarItemContext_1.useSidebarItemContext)();
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.sidebar.item, customTheme);
    return ((0, jsx_runtime_1.jsx)(ListItem, { id: id, isCollapsed: isCollapsed, tooltipChildren: children, children: (0, jsx_runtime_1.jsxs)(Component, { "aria-labelledby": `flowbite-sidebar-item-${id}`, ref: ref, className: (0, classnames_1.default)(theme.base, isActive && theme.active, !isCollapsed && isInsideCollapse && theme.collapsed?.insideCollapse, className), ...props, children: [Icon && ((0, jsx_runtime_1.jsx)(Icon, { "aria-hidden": true, "data-testid": "flowbite-sidebar-item-icon", className: (0, classnames_1.default)(theme.icon?.base, isActive && theme.icon?.active) })), isCollapsed && !Icon && ((0, jsx_runtime_1.jsx)("span", { className: theme.collapsed?.noIcon, children: children.charAt(0).toLocaleUpperCase() ?? '?' })), !isCollapsed && (0, jsx_runtime_1.jsx)(Children, { id: id, children: children }), !isCollapsed && label && ((0, jsx_runtime_1.jsx)(Badge_1.Badge, { color: labelColor, "data-testid": "flowbite-sidebar-label", hidden: isCollapsed, className: theme.label, children: label }))] }) }));
});
SidebarItem.displayName = 'Sidebar.Item';
exports.default = SidebarItem;
