"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = require("react");
const useKeyDown = (key, callback) => {
    (0, react_1.useEffect)(() => {
        const handleKeyDown = (event) => {
            if (event.key === key) {
                callback();
            }
        };
        document.addEventListener('keydown', handleKeyDown);
        return () => {
            document.removeEventListener('keydown', handleKeyDown);
        };
    }, [key, callback]);
};
exports.default = useKeyDown;
