import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
import { useAccordionContext } from './AccordionPanelContext';
export const AccordionTitle = ({ as: Heading = 'h2', children, className, theme: customTheme = {}, ...props }) => {
    const { arrowIcon: ArrowIcon, flush, isOpen, setOpen } = useAccordionContext();
    const onClick = () => typeof setOpen !== 'undefined' && setOpen();
    const theme = mergeDeep(useTheme().theme.accordion.title, customTheme);
    return (_jsxs("button", { className: classNames(theme.base, theme.flush[flush ? 'on' : 'off'], theme.open[isOpen ? 'on' : 'off'], className), onClick: onClick, type: "button", ...props, children: [_jsx(Heading, { className: theme.heading, "data-testid": "flowbite-accordion-heading", children: children }), ArrowIcon && (_jsx(ArrowIcon, { "aria-hidden": true, className: classNames(theme.arrow.base, theme.arrow.open[isOpen ? 'on' : 'off']), "data-testid": "flowbite-accordion-arrow" }))] }));
};
