import type { ComponentProps, FC, PropsWithChildren, ReactNode } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteColors } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteAlertTheme {
    base: string;
    borderAccent: string;
    closeButton: FlowbiteAlertCloseButtonTheme;
    color: FlowbiteColors;
    icon: string;
    rounded: string;
    wrapper: string;
}
export interface FlowbiteAlertCloseButtonTheme {
    base: string;
    color: FlowbiteColors;
    icon: string;
}
export interface AlertProps extends PropsWithChildren<Omit<ComponentProps<'div'>, 'color'>> {
    additionalContent?: ReactNode;
    color?: keyof FlowbiteColors;
    icon?: FC<ComponentProps<'svg'>>;
    onDismiss?: boolean | (() => void);
    rounded?: boolean;
    theme?: DeepPartial<FlowbiteAlertTheme>;
    withBorderAccent?: boolean;
}
export declare const Alert: FC<AlertProps>;
