import type { FC, PropsWithChildren, ReactNode } from 'react';
import React from 'react';
import type { DeepPartial } from '..';
import type { ButtonProps } from '../Button';
import type { FloatingProps, FlowbiteFloatingTheme } from '../Floating';
import type { FlowbiteDropdownDividerTheme } from './DropdownDivider';
import type { FlowbiteDropdownHeaderTheme } from './DropdownHeader';
import type { FlowbiteDropdownItemTheme } from './DropdownItem';
export interface FlowbiteDropdownFloatingTheme extends FlowbiteFloatingTheme, FlowbiteDropdownDividerTheme, FlowbiteDropdownHeaderTheme {
    item: FlowbiteDropdownItemTheme;
}
export interface FlowbiteDropdownTheme {
    floating: FlowbiteDropdownFloatingTheme;
    content: string;
    inlineWrapper: string;
    arrowIcon: string;
}
export interface DropdownProps extends PropsWithChildren, Pick<FloatingProps, 'placement' | 'trigger'>, Omit<ButtonProps, 'theme'> {
    arrowIcon?: boolean;
    dismissOnClick?: boolean;
    floatingArrow?: boolean;
    inline?: boolean;
    label: ReactNode;
    theme?: DeepPartial<FlowbiteDropdownTheme>;
}
export declare const Dropdown: FC<DropdownProps> & {
    Item: FC<import("./DropdownItem").DropdownItemProps>;
    Header: FC<{
        children?: ReactNode;
    } & React.ClassAttributes<HTMLDivElement> & React.HTMLAttributes<HTMLDivElement>>;
    Divider: FC<React.DetailedHTMLProps<React.HTMLAttributes<HTMLDivElement>, HTMLDivElement>>;
};
