import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const FooterDivider = ({ className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.divider, customTheme);
    return _jsx("hr", { "data-testid": "footer-divider", className: classNames(theme.base, className), ...props });
};
