import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const FooterLink = ({ as: Component = 'a', children, className, href, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.groupLink.link, customTheme);
    return (_jsx("li", { className: classNames(theme.base, className), children: _jsx(Component, { href: href, className: theme.href, ...props, children: children }) }));
};
