import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const FooterLinkGroup = ({ children, className, col = false, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.groupLink, customTheme);
    return (_jsx("ul", { "data-testid": "footer-groupLink", className: classNames(theme.base, col && theme.col, className), ...props, children: children }));
};
