import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const FooterTitle = ({ as: Component = 'h2', className, theme: customTheme = {}, title, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.title, customTheme);
    return (_jsx(Component, { "data-testid": "flowbite-footer-title", className: classNames(theme.base, className), ...props, children: title }));
};
