import type { ComponentProps, ElementType, FC, PropsWithChildren } from 'react';
import type { LinkProps } from 'react-router-dom';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteNavbarLinkTheme {
    base: string;
    active: FlowbiteBoolean;
    disabled: FlowbiteBoolean;
}
export interface NavbarLinkProps extends PropsWithChildren<ComponentProps<'a'>>, Partial<Pick<LinkProps, 'to'>> {
    active?: boolean;
    as?: ElementType;
    disabled?: boolean;
    href?: string;
    theme?: DeepPartial<FlowbiteNavbarLinkTheme>;
}
export declare const NavbarLink: FC<NavbarLinkProps>;
