import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite';
export const TimelineTitle = ({ as: Tag = 'h3', children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.timeline.item.content, customTheme).title;
    return (_jsx(Tag, { className: classNames(theme, className), ...props, children: children }));
};
