import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { HiX } from 'react-icons/hi';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
import { useToastContext } from './ToastContext';
export const ToastToggle = ({ className, theme: customTheme = {}, xIcon: XIcon = HiX, ...props }) => {
    const theme = mergeDeep(useTheme().theme.toast.toggle, customTheme);
    const { duration, isClosed, isRemoved, setIsClosed, setIsRemoved } = useToastContext();
    const handleClick = () => {
        setIsClosed(!isClosed);
        setTimeout(() => setIsRemoved(!isRemoved), duration);
    };
    return (_jsx("button", { "aria-label": "Close", onClick: handleClick, type: "button", className: classNames(theme.base, className), ...props, children: _jsx(XIcon, { "aria-hidden": true, className: theme.icon }) }));
};
