var defaultValidate = function defaultValidate(locale) {
  return locale;
};

var parseAcceptLanguage = function parseAcceptLanguage(
/** The value from the `Accept-Language` header.
 * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language
 */
languageHeaderValue, options) {
  if (options === void 0) {
    options = {};
  }

  if (!languageHeaderValue) return [];
  var _options = options,
      _options$ignoreWildca = _options.ignoreWildcard,
      ignoreWildcard = _options$ignoreWildca === void 0 ? true : _options$ignoreWildca,
      _options$validate = _options.validate,
      validate = _options$validate === void 0 ? defaultValidate : _options$validate;
  return languageHeaderValue.split(',').map(function (lang) {
    var _lang$split = lang.split(';'),
        locale = _lang$split[0],
        _lang$split$ = _lang$split[1],
        q = _lang$split$ === void 0 ? 'q=1' : _lang$split$;

    var trimmedLocale = locale.trim();
    var numQ = Number(q.replace(/q ?=/, ''));
    if (isNaN(numQ)) return [0, trimmedLocale];
    return [numQ, trimmedLocale];
  }).sort(function (_ref, _ref2) {
    var q1 = _ref[0];
    var q2 = _ref2[0];
    return q2 - q1;
  }).flatMap(function (_ref3) {
    var locale = _ref3[1];
    if (locale === '*' && ignoreWildcard) return [];

    try {
      return validate(locale) || []; // return Intl.DateTimeFormat.supportedLocalesOf(locale);
    } catch (_unused) {
      return [];
    }
  });
};

export { parseAcceptLanguage };
//# sourceMappingURL=intl-parse-accept-language.esm.js.map
