import { type InputMask, type InputMaskElement, type FactoryOpts } from 'imask';
import { Dispatch } from 'react';
import type { MutableRefObject } from 'react';
import type { ReactMaskProps } from './mixin';
export default function useIMask<MaskElement extends InputMaskElement, Opts extends FactoryOpts>(opts: Opts, { onAccept, onComplete }?: Partial<Pick<ReactMaskProps<MaskElement, Opts>, 'onAccept' | 'onComplete'>>): {
    ref: MutableRefObject<MaskElement | null>;
    maskRef: MutableRefObject<InputMask<Opts> | null>;
    value: InputMask<Opts>['value'];
    setValue: Dispatch<InputMask<Opts>['value']>;
    unmaskedValue: InputMask<Opts>['unmaskedValue'];
    setUnmaskedValue: Dispatch<InputMask<Opts>['unmaskedValue']>;
    typedValue: InputMask<Opts>['typedValue'];
    setTypedValue: Dispatch<InputMask<Opts>['typedValue']>;
};
//# sourceMappingURL=hook.d.ts.map