import { ReactNode } from "react";
declare type Props = {
    /**
     * You are encouraged to add a fallback that is the same dimensions
     * as the client rendered children. This will avoid content layout
     * shift which is disgusting
     */
    children(): ReactNode;
    fallback?: ReactNode;
};
/**
 * Render the children only after the JS has loaded client-side. Use an optional
 * fallback component if the JS is not yet loaded.
 *
 * Example: Render a Chart component if JS loads, renders a simple FakeChart
 * component server-side or if there is no JS. The FakeChart can have only the
 * UI without the behavior or be a loading spinner or skeleton.
 * ```tsx
 * return (
 *   <ClientOnly fallback={<FakeChart />}>
 *     {() => <Chart />}
 *   </ClientOnly>
 * );
 * ```
 */
export declare function ClientOnly({ children, fallback }: Props): JSX.Element;
export {};
