/**
 * A response holper to use Server Sent Events server-side
 * @param signal The AbortSignal used to close the stream
 * @param init The function that will be called to initialize the stream, here you can subscribe to your events
 * @returns A Response object that can be returned from a loader
 */
export function eventStream(signal, init) {
    let stream = new ReadableStream({
        start(controller) {
            let encoder = new TextEncoder();
            function send({ event = "message", data }) {
                controller.enqueue(encoder.encode(`event: ${event}\n`));
                controller.enqueue(encoder.encode(`data: ${data}\n\n`));
            }
            let cleanup = init(send);
            let closed = false;
            function close() {
                if (closed)
                    return;
                cleanup();
                closed = true;
                signal.removeEventListener("abort", close);
                controller.close();
            }
            signal.addEventListener("abort", close);
            if (signal.aborted)
                return close();
        },
    });
    return new Response(stream, {
        headers: {
            "Content-Type": "text/event-stream",
            "Cache-Control": "no-cache",
            Connection: "keep-alive",
        },
    });
}
