/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './app/**/*.{js,jsx,ts,tsx}',
    './node_modules/flowbite-react/**/*.{js,jsx,ts,tsx}',
    './node_modules/tw-elements/dist/js/**/*.{js,jsx,ts,tsx}'
  ],
  theme: {
    extend: {
      fontFamily: {
        MontserratBold: ["MontserratBold"],
        MontserratMedium: ["MontserratMedium"],
        MontserratRegular: ["MontserratRegular"],
        MontserratSemiBold: ["MontserratSemiBold"],
        MontserratThin: ["MontserratThin"], 
        MontserratLight: ["MontserratLight"]
      },
      colors: {
        eBlue: "#2770ca !important",
        eBlack: "#191e25 !important",
        eGray: "#414955 !important",
        eLightGray: "#f3f3f3 !important",
        eYellow: "#eabb2e !important",
        eRed: "#ff4242 !important",
        eGreen: "#b6dc79 !important",
      },
      backgroundImage: {
        checkPattern: "url('../public/assets/img/check-icon.webp') !important",
        dropPattern: "url('../public/assets/img/btn-drop.webp') !important",
        checkFortalezas: "url('../public/assets/img/check.webp') !important",
        backFortalezas: "url('../public/assets/img/back.webp') !important",
      },
      aria: {
        current: 'current="true"',
      }
    },
  },
  plugins: [
    require('flowbite/plugin'),
    require("tw-elements/dist/plugin")
  ],
}

