"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Card = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const tailwind_merge_1 = require("tailwind-merge");
const __1 = require("../../");
const merge_deep_1 = require("../../helpers/merge-deep");
const Card = ({ children, className, horizontal, href, imgAlt, imgSrc, theme: customTheme = {}, ...props }) => {
    const Component = typeof href === 'undefined' ? 'div' : 'a';
    const theirProps = props;
    const theme = (0, merge_deep_1.mergeDeep)((0, __1.useTheme)().theme.card, customTheme);
    return ((0, jsx_runtime_1.jsxs)(Component, { "data-testid": "flowbite-card", href: href, className: (0, tailwind_merge_1.twMerge)(theme.root.base, theme.root.horizontal[horizontal ? 'on' : 'off'], href && theme.root.href, className), ...theirProps, children: [imgSrc && ((0, jsx_runtime_1.jsx)("img", { alt: imgAlt ?? '', src: imgSrc, className: (0, tailwind_merge_1.twMerge)(theme.img.base, theme.img.horizontal[horizontal ? 'on' : 'off']) })), (0, jsx_runtime_1.jsx)("div", { className: theme.root.children, children: children })] }));
};
exports.Card = Card;
exports.Card.displayName = 'Card';
