"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useThemeMode = exports.useTheme = exports.ThemeProvider = exports.ThemeContext = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const is_client_1 = require("../../helpers/is-client");
const theme_1 = require("../../theme");
exports.ThemeContext = (0, react_1.createContext)({
    theme: theme_1.theme,
});
const ThemeProvider = ({ children, value }) => {
    return (0, jsx_runtime_1.jsx)(exports.ThemeContext.Provider, { value: value, children: children });
};
exports.ThemeProvider = ThemeProvider;
const useTheme = () => {
    return (0, react_1.useContext)(exports.ThemeContext);
};
exports.useTheme = useTheme;
const prefersColorScheme = () => {
    if (!(0, is_client_1.isClient)()) {
        return 'light';
    }
    return window.matchMedia?.('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
};
const useThemeMode = () => {
    const onToggleMode = () => {
        const newMode = mode === 'dark' ? 'light' : 'dark';
        setModeOnBody(newMode);
        setMode(newMode);
    };
    const setModeOnBody = (0, react_1.useCallback)((mode) => {
        if (!(0, is_client_1.isClient)()) {
            return;
        }
        if (mode === 'dark') {
            document.documentElement.classList.add('dark');
        }
        else {
            document.documentElement.classList.remove('dark');
        }
    }, []);
    const { mode: initialMode, toggleMode = onToggleMode } = (0, react_1.useContext)(exports.ThemeContext);
    const [mode, setMode] = (0, react_1.useState)('light');
    (0, react_1.useEffect)(() => {
        if (initialMode) {
            setModeOnBody(initialMode);
            setMode(initialMode);
        }
        else {
            setMode(prefersColorScheme());
        }
    }, [initialMode, setModeOnBody, setMode]);
    return [mode, setMode, toggleMode];
};
exports.useThemeMode = useThemeMode;
