"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NavbarCollapse = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const tailwind_merge_1 = require("tailwind-merge");
const __1 = require("../../");
const merge_deep_1 = require("../../helpers/merge-deep");
const NavbarContext_1 = require("./NavbarContext");
const NavbarCollapse = ({ children, className, theme: customTheme = {}, ...props }) => {
    const { isOpen } = (0, NavbarContext_1.useNavbarContext)();
    const theme = (0, merge_deep_1.mergeDeep)((0, __1.useTheme)().theme.navbar.collapse, customTheme);
    return ((0, jsx_runtime_1.jsx)("div", { "data-testid": "flowbite-navbar-collapse", className: (0, tailwind_merge_1.twMerge)(theme.base, theme.hidden[!isOpen ? 'on' : 'off'], className), ...props, children: (0, jsx_runtime_1.jsx)("ul", { className: theme.list, children: children }) }));
};
exports.NavbarCollapse = NavbarCollapse;
