"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimelineContent = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const tailwind_merge_1 = require("tailwind-merge");
const __1 = require("../../");
const merge_deep_1 = require("../../helpers/merge-deep");
const TimelineContext_1 = require("./TimelineContext");
const TimelineContent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = (0, merge_deep_1.mergeDeep)((0, __1.useTheme)().theme.timeline.item.content, customTheme);
    const { horizontal } = (0, TimelineContext_1.useTimelineContext)();
    return ((0, jsx_runtime_1.jsx)("div", { "data-testid": "timeline-content", className: (0, tailwind_merge_1.twMerge)(horizontal && theme.root.base, className), ...props, children: children }));
};
exports.TimelineContent = TimelineContent;
