import { jsxs as _jsxs } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const AvatarGroupCounter = ({ className, href, theme: customTheme = {}, total, ...props }) => {
    const theme = mergeDeep(useTheme().theme.avatar.groupCounter, customTheme);
    return (_jsxs("a", { href: href, className: twMerge(theme.base, className), ...props, children: ["+", total] }));
};
AvatarGroupCounter.displayName = 'Avatar.GroupCounter';
