import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { BreadcrumbItem } from './BreadcrumbItem';
const BreadcrumbComponent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.breadcrumb.root, customTheme);
    return (_jsx("nav", { "aria-label": "Breadcrumb", className: twMerge(theme.base, className), ...props, children: _jsx("ol", { className: theme.list, children: children }) }));
};
BreadcrumbComponent.displayName = 'Breadcrumb';
export const Breadcrumb = Object.assign(BreadcrumbComponent, { Item: BreadcrumbItem });
