import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useListItem } from '@floating-ui/react';
import { useContext } from 'react';
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { ButtonBase } from '../Button/ButtonBase';
import { DropdownContext } from './Dropdown';
export const DropdownItem = ({ children, className, icon: Icon, onClick, theme: customTheme = {}, ...props }) => {
    const { ref, index } = useListItem({ label: typeof children === 'string' ? children : undefined });
    const { activeIndex, dismissOnClick, getItemProps, handleSelect } = useContext(DropdownContext);
    const isActive = activeIndex === index;
    const theme = mergeDeep(useTheme().theme.dropdown.floating.item, customTheme);
    return (_jsx("li", { role: "menuitem", className: theme.container, children: _jsxs(ButtonBase, { ref: ref, className: twMerge(theme.base, className), ...props, ...getItemProps({
                onClick: () => {
                    onClick && onClick();
                    dismissOnClick && handleSelect(null);
                },
            }), tabIndex: isActive ? 0 : -1, children: [Icon && _jsx(Icon, { className: theme.icon }), children] }) }));
};
