import type { Dispatch, FC, ReactNode, SetStateAction } from 'react';
import type { FlowbiteTheme } from './FlowbiteTheme';
export type Mode = 'light' | 'dark';
export interface ThemeContextProps {
    mode?: Mode;
    theme: FlowbiteTheme;
    toggleMode?: () => void | null;
}
export declare const ThemeContext: import("react").Context<ThemeContextProps>;
interface ThemeProviderProps {
    children: ReactNode;
    value: ThemeContextProps;
}
export declare const ThemeProvider: FC<ThemeProviderProps>;
export declare const useTheme: () => ThemeContextProps;
export declare const useThemeMode: () => [Mode, Dispatch<SetStateAction<Mode>>, () => void];
export {};
