import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const FooterLinkGroup = ({ children, className, col = false, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.footer.groupLink, customTheme);
    return (_jsx("ul", { "data-testid": "footer-groupLink", className: twMerge(theme.base, col && theme.col, className), ...props, children: children }));
};
