import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { useModalContext } from './ModalContext';
export const ModalFooter = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.modal.footer, customTheme);
    const { popup } = useModalContext();
    return (_jsx("div", { className: twMerge(theme.base, !popup && theme.popup, className), ...props, children: children }));
};
