import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial, FlowbiteBoolean } from '../../';
import type { SidebarItemProps } from './SidebarItem';
export interface FlowbiteSidebarCollapseTheme {
    button: string;
    icon: {
        base: string;
        open: FlowbiteBoolean;
    };
    label: {
        base: string;
        icon: string;
    };
    list: string;
}
export interface SidebarCollapseProps extends PropsWithChildren, Pick<SidebarItemProps, 'active' | 'as' | 'href' | 'icon' | 'label' | 'labelColor'>, ComponentProps<'button'> {
    onClick?: ComponentProps<'button'>['onClick'];
    open?: boolean;
    theme?: DeepPartial<FlowbiteSidebarCollapseTheme>;
}
export declare const SidebarCollapse: FC<SidebarCollapseProps>;
