import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
export const TimelineBody = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.timeline.item.content, customTheme).body;
    return (_jsx("div", { className: twMerge(theme, className), ...props, children: children }));
};
