import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { useTimelineContext } from './TimelineContext';
export const TimelineContent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.timeline.item.content, customTheme);
    const { horizontal } = useTimelineContext();
    return (_jsx("div", { "data-testid": "timeline-content", className: twMerge(horizontal && theme.root.base, className), ...props, children: children }));
};
