import { jsx as _jsx } from "react/jsx-runtime";
import { HiX } from 'react-icons/hi';
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { useToastContext } from './ToastContext';
export const ToastToggle = ({ className, onClick, theme: customTheme = {}, xIcon: XIcon = HiX, ...props }) => {
    const theme = mergeDeep(useTheme().theme.toast.toggle, customTheme);
    const { duration, isClosed, isRemoved, setIsClosed, setIsRemoved } = useToastContext();
    const handleClick = (e) => {
        if (onClick)
            onClick(e);
        setIsClosed(!isClosed);
        setTimeout(() => setIsRemoved(!isRemoved), duration);
    };
    return (_jsx("button", { "aria-label": "Close", onClick: handleClick, type: "button", className: twMerge(theme.base, className), ...props, children: _jsx(XIcon, { "aria-hidden": true, className: theme.icon }) }));
};
