import { jsx as _jsx } from "react/jsx-runtime";
import { useTheme } from '../../';
import { Floating } from '../../components/Floating';
import { mergeDeep } from '../../helpers/merge-deep';
/**
 * @see https://floating-ui.com/docs/react-dom-interactions
 */
export const Tooltip = ({ animation = 'duration-300', arrow = true, children, className, content, placement = 'top', style = 'dark', theme: customTheme = {}, trigger = 'hover', ...props }) => {
    const theme = mergeDeep(useTheme().theme.tooltip, customTheme);
    return (_jsx(Floating, { animation: animation, arrow: arrow, content: content, placement: placement, style: style, theme: theme, trigger: trigger, className: className, ...props, children: children }));
};
Tooltip.displayName = 'Tooltip';
