import { createElement as _createElement } from "react";
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useLocation, useMatches } from "@remix-run/react";
export function ExternalScripts() {
    let location = useLocation();
    let scripts = useMatches().flatMap((match, index, matches) => {
        var _a;
        let scripts = (_a = match.handle) === null || _a === void 0 ? void 0 : _a.scripts;
        if (typeof scripts !== "function")
            return [];
        let result = scripts({
            id: match.id,
            data: match.data,
            params: match.params,
            location,
            parentsData: matches.slice(0, index).map((match) => match.data),
            matches,
        });
        if (Array.isArray(result))
            return result;
        return [];
    });
    return (_jsxs(_Fragment, { children: [scripts.map((props) => {
                let rel = props.noModule ? "modulepreload" : "preload";
                let as = !props.noModule ? "script" : undefined;
                return (_jsx("link", { rel: rel, href: props.src, as: as, crossOrigin: props.crossOrigin, integrity: props.integrity, referrerPolicy: props.referrerPolicy }, props.src));
            }), scripts.map((props) => {
                return _createElement("script", { ...props, key: props.src });
            })] }));
}
